/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterBaseVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.DateTimeVisitors;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.DoubleVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.GeoGeographyVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.IntegerVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.InvalidResultTypeException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.MethodCallExprVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ResourceValueFilterInputHolder;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.StringVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.PathHandler;

public class CommonExprVisitor
extends ODataFilterBaseVisitor<Function<ResourceValueFilterInputHolder, Object>> {
    private final Parser parser;
    private final GeoGeographyVisitor visitor;

    public CommonExprVisitor(Parser parser) {
        this.parser = parser;
        this.visitor = new GeoGeographyVisitor();
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitPrimitiveliteral(ODataFilterParser.PrimitiveliteralContext ctx) {
        ParserRuleContext element = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, 0);
        switch (element.getRuleIndex()) {
            case 180: {
                return x -> null;
            }
            case 186: {
                return x -> "true".equalsIgnoreCase(ctx.getText());
            }
            case 187: 
            case 188: {
                Double value = (Double)new DoubleVisitor().visitChildren((RuleNode)ctx);
                return x -> value;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: {
                Integer value = (Integer)new IntegerVisitor().visitChildren((RuleNode)ctx);
                return x -> value;
            }
            case 197: {
                String value = (String)new StringVisitor().visitChildren((RuleNode)ctx);
                return x -> value;
            }
            case 200: {
                OffsetDateTime value = DateTimeVisitors.dateTimeOffset(element);
                return x -> value;
            }
            case 199: {
                LocalDate value = DateTimeVisitors.date(element);
                return x -> value;
            }
            case 203: {
                LocalTime value = DateTimeVisitors.timeOfDay(element);
                return x -> value;
            }
            case 201: {
                Duration value = DateTimeVisitors.duration(element);
                return x -> value;
            }
            case 217: 
            case 221: 
            case 225: 
            case 228: 
            case 231: 
            case 234: 
            case 240: {
                GeoJsonObject value = (GeoJsonObject)this.visitor.visit((ParseTree)element);
                return x -> value;
            }
        }
        throw new UnsupportedRuleException(this.parser, element);
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitNegateexpr(ODataFilterParser.NegateexprContext ctx) {
        Object subExpr = this.visitCommonexpr(ctx.commonexpr());
        return arg_0 -> CommonExprVisitor.lambda$visitNegateexpr$10((Function)subExpr, arg_0);
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitParenexpr(ODataFilterParser.ParenexprContext ctx) {
        return this.visitCommonexpr(ctx.commonexpr());
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitMethodcallexpr(ODataFilterParser.MethodcallexprContext ctx) {
        return (Function)new MethodCallExprVisitor(this.parser).visit((ParseTree)ctx);
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitFirstmemberexpr(ODataFilterParser.FirstmemberexprContext ctx) {
        return new PathHandler(ctx.getText())::handle;
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitCommonexpr(ODataFilterParser.CommonexprContext ctx) {
        BiFunction<Object, Object, Object> subOperation;
        Function rightExpr;
        Function firstExpr = (Function)this.visit(ctx.getChild(0));
        if (ctx.getChildCount() == 1) {
            return firstExpr;
        }
        ParserRuleContext rightElement = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, 1);
        CommonExprVisitor rightVisitor = new CommonExprVisitor(this.parser);
        switch (rightElement.getRuleIndex()) {
            case 102: {
                rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.AddexprContext)rightElement).commonexpr());
                subOperation = this::add;
                break;
            }
            case 103: {
                rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.SubexprContext)rightElement).commonexpr());
                subOperation = this::sub;
                break;
            }
            case 104: {
                rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.MulexprContext)rightElement).commonexpr());
                subOperation = this::mul;
                break;
            }
            case 105: {
                rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.DivexprContext)rightElement).commonexpr());
                subOperation = this::div;
                break;
            }
            case 106: {
                rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.ModexprContext)rightElement).commonexpr());
                subOperation = this::mod;
                break;
            }
            default: {
                throw new UnsupportedRuleException("Unexpected right operator", this.parser, rightElement);
            }
        }
        return x -> {
            Object leftValue = firstExpr.apply(x);
            Object rightValue = rightExpr.apply(x);
            return subOperation.apply(leftValue, rightValue);
        };
    }

    private Object add(Object l, Object r) {
        if (l instanceof Number && r instanceof Number) {
            if (l instanceof Integer && r instanceof Integer) {
                return (Integer)l + (Integer)r;
            }
            return ((Number)l).doubleValue() + ((Number)r).doubleValue();
        }
        if (l instanceof String || r instanceof String) {
            return String.valueOf(l) + String.valueOf(r);
        }
        if (r instanceof Duration) {
            Duration duration = (Duration)r;
            if (l instanceof Temporal) {
                return duration.addTo((Temporal)l);
            }
        }
        throw new InvalidResultTypeException("Can't add", "numbers", l, r);
    }

    private Object sub(Object l, Object r) {
        if (l instanceof Number && r instanceof Number) {
            if (l instanceof Integer && r instanceof Integer) {
                return (Integer)l - (Integer)r;
            }
            return ((Number)l).doubleValue() - ((Number)r).doubleValue();
        }
        if (r instanceof Duration) {
            Duration duration = (Duration)r;
            if (l instanceof Temporal) {
                return duration.negated().addTo((Temporal)l);
            }
        } else if (l instanceof Temporal && r instanceof Temporal) {
            return Duration.between((Temporal)r, (Temporal)l);
        }
        throw new InvalidResultTypeException("Can't substract", "numbers", l, r);
    }

    private Object mul(Object l, Object r) {
        if (l instanceof Number && r instanceof Number) {
            if (l instanceof Integer && r instanceof Integer) {
                return (Integer)l * (Integer)r;
            }
            return ((Number)l).doubleValue() * ((Number)r).doubleValue();
        }
        throw new InvalidResultTypeException("Can't multiply", "numbers", l, r);
    }

    private Object div(Object l, Object r) {
        if (l instanceof Number && r instanceof Number) {
            return ((Number)l).doubleValue() / ((Number)r).doubleValue();
        }
        throw new InvalidResultTypeException("Can't divide", "numbers", l, r);
    }

    private Object mod(Object l, Object r) {
        if (l instanceof Integer && r instanceof Integer) {
            return (Integer)l % (Integer)r;
        }
        throw new InvalidResultTypeException("Can't apply modulus", "integers", l, r);
    }

    private static /* synthetic */ Object lambda$visitNegateexpr$10(Function subExpr, ResourceValueFilterInputHolder x) {
        Object res = subExpr.apply(x);
        if (res instanceof Number) {
            if (res instanceof Integer) {
                return -((Integer)res).intValue();
            }
            return -((Number)res).doubleValue();
        }
        throw new InvalidResultTypeException("Can't negate", "number", res);
    }
}

