/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.northbound.filters.api.FilterCommandHelper;
import org.eclipse.sensinact.northbound.filters.api.FilterException;
import org.eclipse.sensinact.northbound.filters.api.IFilterHandler;
import org.eclipse.sensinact.northbound.query.api.AbstractQueryDTO;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EReadWriteMode;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.query.api.StatusException;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.query.QueryActDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryDescribeDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryGetDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryListDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QuerySetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.AccessMethodDTO;
import org.eclipse.sensinact.northbound.query.dto.result.AccessMethodParameterDTO;
import org.eclipse.sensinact.northbound.query.dto.result.CompleteProviderDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ErrorResultDTO;
import org.eclipse.sensinact.northbound.query.dto.result.MetadataDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeResourceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeServiceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseSetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultActDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultDescribeProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListResourcesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListServicesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ShortResourceDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.query.impl.UpdatableCriterion;
import org.eclipse.sensinact.northbound.session.ProviderDescription;
import org.eclipse.sensinact.northbound.session.ResourceDescription;
import org.eclipse.sensinact.northbound.session.ResourceShortDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.ServiceDescription;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.Promises;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IQueryHandler.class}, immediate=true)
public class QueryHandler
implements IQueryHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryHandler.class);
    private static final String DEFAULT_FILTER_LANGUAGE = "ldap";
    @Reference
    GatewayThread gatewayThread;
    private AtomicReference<IFilterHandler> filterHandlerRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setFilterHandler(IFilterHandler filterHandler) {
        AtomicReference<IFilterHandler> atomicReference = this.filterHandlerRef;
        synchronized (atomicReference) {
            this.filterHandlerRef.set(filterHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetFilterHandler(IFilterHandler filterHandler) {
        AtomicReference<IFilterHandler> atomicReference = this.filterHandlerRef;
        synchronized (atomicReference) {
            this.filterHandlerRef.set(null);
        }
    }

    @Override
    public AbstractResultDTO handleQuery(SensiNactSession userSession, AbstractQueryDTO query) {
        AbstractResultDTO result;
        try {
            switch (query.operation) {
                case LIST: {
                    result = this.handleList(userSession, (QueryListDTO)query);
                    break;
                }
                case DESCRIBE: {
                    result = this.handleDescribe(userSession, (QueryDescribeDTO)query);
                    break;
                }
                case GET: {
                    result = this.handleGet(userSession, (QueryGetDTO)query);
                    break;
                }
                case SET: {
                    result = this.handleSet(userSession, (QuerySetDTO)query);
                    break;
                }
                case ACT: {
                    result = this.handleAct(userSession, (QueryActDTO)query);
                    break;
                }
                default: {
                    result = new ErrorResultDTO(501, "Operation not implemented");
                    break;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error handling query {} on {}: {}", new Object[]{query.operation, query.uri, t.getMessage(), t});
            result = new ErrorResultDTO(t);
        }
        if (result == null) {
            result = new ErrorResultDTO(204, "No content");
        }
        if (result.uri == null) {
            result.uri = query.uri.toUri();
        }
        if (query.requestId != null) {
            result.requestId = query.requestId;
        }
        return result;
    }

    @Override
    public ICriterion parseFilter(String filter, String filterLanguage) throws StatusException {
        AtomicReference<IFilterHandler> atomicReference = this.filterHandlerRef;
        synchronized (atomicReference) {
            IFilterHandler filterHandler = this.filterHandlerRef.get();
            if (filterHandler == null) {
                throw new StatusException(501, "No filter implementation available");
            }
            try {
                return filterHandler.parseFilter(filterLanguage != null ? filterLanguage : DEFAULT_FILTER_LANGUAGE, filter);
            }
            catch (Throwable t) {
                throw new StatusException(500, "Error parsing filter: " + t.getMessage());
            }
        }
    }

    private AbstractResultDTO handleList(SensiNactSession userSession, QueryListDTO dto) throws Exception {
        SensinactPath path = dto.uri;
        if (path == null || path.isEmpty()) {
            return this.listProviders(userSession, dto);
        }
        if (path.targetsSpecificProvider()) {
            return this.listServices(userSession, dto, path.provider);
        }
        if (path.targetsSpecificService()) {
            return this.listResources(userSession, dto, path.provider, path.service);
        }
        return new ErrorResultDTO(405, "List operation can be applied on the root, a specific provider or a specific service.");
    }

    private AbstractResultDTO handleDescribe(SensiNactSession userSession, QueryDescribeDTO dto) throws Exception {
        SensinactPath path = dto.uri;
        if (path == null || path.isEmpty()) {
            return this.describeProviders(userSession, dto);
        }
        if (path.targetsSpecificProvider()) {
            return this.describeProvider(userSession, path.provider);
        }
        if (path.targetsSpecificService()) {
            return this.describeService(userSession, path.provider, path.service);
        }
        if (path.targetsSpecificResource()) {
            return this.describeResource(userSession, path.provider, path.service, path.resource);
        }
        return new ErrorResultDTO(405, "Describe only works on specific provider, service or resource");
    }

    private AbstractResultDTO handleGet(SensiNactSession userSession, QueryGetDTO dto) {
        SensinactPath path = dto.uri;
        if (path == null || !path.targetsSpecificResource() && !path.targetsSpecificMetadata()) {
            return new ErrorResultDTO(405, "GET only works on specific resource or metadata");
        }
        if (path.targetsSpecificMetadata()) {
            return new ErrorResultDTO(501, "Not implemented");
        }
        ResourceDescription rcDesc = userSession.describeResource(path.provider, path.service, path.resource);
        if (rcDesc == null) {
            return new ErrorResultDTO(404, "Resource not found");
        }
        ResourceShortDescription rcShortDesc = userSession.describeResourceShort(path.provider, path.service, path.resource);
        TypedResponse result = new TypedResponse(EResultType.GET_RESPONSE);
        result.response = new ResponseGetDTO();
        ((ResponseGetDTO)result.response).name = rcDesc.resource;
        if (rcShortDesc.contentType != null) {
            ((ResponseGetDTO)result.response).type = rcShortDesc.contentType.getName();
        } else if (rcDesc.value != null) {
            ((ResponseGetDTO)result.response).type = rcDesc.value.getClass().getName();
        }
        if (rcDesc.timestamp != null) {
            result.statusCode = 200;
            ((ResponseGetDTO)result.response).value = rcDesc.value;
            ((ResponseGetDTO)result.response).timestamp = rcDesc.timestamp.toEpochMilli();
        } else {
            result.statusCode = 204;
            result.error = "No value set";
            ((ResponseGetDTO)result.response).value = null;
            ((ResponseGetDTO)result.response).timestamp = Instant.now().toEpochMilli();
        }
        return result;
    }

    private AbstractResultDTO handleSet(SensiNactSession userSession, QuerySetDTO dto) {
        SensinactPath path = dto.uri;
        if (!path.targetsSpecificResource() && !path.targetsSpecificMetadata()) {
            return new ErrorResultDTO(405, "Can only set a resource or its metadata");
        }
        TypedResponse result = new TypedResponse(EResultType.SET_RESPONSE);
        ResponseSetDTO response = new ResponseSetDTO();
        Instant timestamp = Instant.now();
        Object newValue = dto.value;
        if (path.targetsSpecificResource()) {
            response.name = path.resource;
            userSession.setResourceValue(path.provider, path.service, path.resource, newValue, timestamp);
        } else {
            response.name = path.resource + "/" + path.metadata;
            userSession.setResourceMetadata(path.provider, path.service, path.resource, path.metadata, newValue);
        }
        if (path.targetsSpecificResource()) {
            ResourceShortDescription rcShortDesc = userSession.describeResourceShort(path.provider, path.service, path.resource);
            response.timestamp = timestamp.toEpochMilli();
            response.type = rcShortDesc.contentType.getName();
        } else {
            response.timestamp = timestamp.toEpochMilli();
            response.type = null;
        }
        response.value = newValue;
        result.response = response;
        result.statusCode = 200;
        return result;
    }

    private AbstractResultDTO handleAct(SensiNactSession userSession, QueryActDTO dto) {
        SensinactPath path = dto.uri;
        if (!path.targetsSpecificResource()) {
            return new ErrorResultDTO(405, "ACT can only be used on resources");
        }
        ResultActDTO result = new ResultActDTO();
        result.statusCode = 200;
        result.response = userSession.actOnResource(path.provider, path.service, path.resource, dto.parameters);
        return result;
    }

    private Collection<ProviderSnapshot> executeFilter(String filter, String filterLanguage) throws StatusException {
        ICriterion parsedFilter = this.parseFilter(filter, filterLanguage);
        try {
            return FilterCommandHelper.executeFilter((GatewayThread)this.gatewayThread, (ICriterion)parsedFilter);
        }
        catch (FilterException e) {
            throw new StatusException(500, "Error executing filter: " + e.getMessage());
        }
    }

    private AbstractResultDTO listProviders(SensiNactSession userSession, QueryListDTO query) throws Exception {
        ResultListProvidersDTO result = new ResultListProvidersDTO();
        if (query.filter != null && !query.filter.isBlank()) {
            Collection<ProviderSnapshot> filteredSnapshot;
            try {
                filteredSnapshot = this.executeFilter(query.filter, query.filterLanguage);
            }
            catch (StatusException e) {
                return e.toErrorResult();
            }
            result.providers = filteredSnapshot.stream().map(p -> p.getName()).collect(Collectors.toList());
            result.statusCode = 200;
        } else {
            result.providers = userSession.listProviders().stream().map(provider -> provider.provider).collect(Collectors.toList());
            result.statusCode = 200;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractResultDTO listServices(SensiNactSession userSession, QueryListDTO query, String providerId) throws Exception {
        ProviderDescription providerDescr = userSession.describeProvider(providerId);
        if (providerDescr == null) {
            return new ErrorResultDTO(404, "Unknown provider");
        }
        ResultListServicesDTO result = new ResultListServicesDTO();
        if (query.filter != null && !query.filter.isBlank()) {
            Collection filteredSnapshot;
            ICriterion parsedFilter;
            AtomicReference<IFilterHandler> atomicReference = this.filterHandlerRef;
            synchronized (atomicReference) {
                parsedFilter = this.parseFilter(query.filter, query.filterLanguage);
            }
            UpdatableCriterion updatedCriterion = new UpdatableCriterion(parsedFilter);
            updatedCriterion.addProviderFilter(p -> providerId.equals(p.getName()));
            try {
                filteredSnapshot = FilterCommandHelper.executeFilter((GatewayThread)this.gatewayThread, (ICriterion)updatedCriterion);
            }
            catch (Throwable t) {
                return new ErrorResultDTO(500, "Error executing filter: " + t.getMessage());
            }
            if (filteredSnapshot.isEmpty()) {
                result.services = List.of();
            } else {
                ProviderSnapshot provider = (ProviderSnapshot)filteredSnapshot.iterator().next();
                ResourceValueFilter resourceValueFilter = updatedCriterion.getResourceValueFilter();
                List services = resourceValueFilter != null ? provider.getServices().stream().filter(s -> resourceValueFilter.test(provider, s.getResources())).collect(Collectors.toList()) : provider.getServices();
                result.services = services.stream().map(s -> s.getName()).collect(Collectors.toList());
            }
            result.statusCode = 200;
        } else {
            result.services = providerDescr.services;
            result.statusCode = 200;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractResultDTO listResources(SensiNactSession userSession, QueryListDTO query, String providerId, String serviceId) throws Exception {
        ServiceDescription serviceDescr = userSession.describeService(providerId, serviceId);
        if (serviceDescr == null) {
            return new ErrorResultDTO(404, "Unknown service");
        }
        ResultListResourcesDTO result = new ResultListResourcesDTO();
        if (query.filter != null && !query.filter.isBlank()) {
            Collection filteredSnapshot;
            ICriterion parsedFilter;
            AtomicReference<IFilterHandler> atomicReference = this.filterHandlerRef;
            synchronized (atomicReference) {
                parsedFilter = this.parseFilter(query.filter, query.filterLanguage);
            }
            UpdatableCriterion updatedCriterion = new UpdatableCriterion(parsedFilter);
            updatedCriterion.addProviderFilter(p -> providerId.equals(p.getName()));
            try {
                filteredSnapshot = FilterCommandHelper.executeFilter((GatewayThread)this.gatewayThread, (ICriterion)updatedCriterion);
            }
            catch (Throwable t) {
                return new ErrorResultDTO(500, "Error executing filter: " + t.getMessage());
            }
            if (filteredSnapshot.isEmpty()) {
                result.resources = List.of();
            } else {
                ProviderSnapshot provider = (ProviderSnapshot)filteredSnapshot.iterator().next();
                Optional<ServiceSnapshot> service = provider.getServices().stream().filter(s -> serviceId.equals(s.getName())).findFirst();
                if (service.isEmpty()) {
                    result.resources = List.of();
                } else {
                    ResourceValueFilter resourceValueFilter = updatedCriterion.getResourceValueFilter();
                    List resources = resourceValueFilter != null ? service.get().getResources().stream().filter(r -> resourceValueFilter.test(provider, List.of(r))).collect(Collectors.toList()) : service.get().getResources();
                    result.resources = resources.stream().map(s -> s.getName()).collect(Collectors.toList());
                }
            }
            result.statusCode = 200;
        } else {
            result.resources = serviceDescr.resources;
            result.statusCode = 200;
        }
        return result;
    }

    private AccessMethodParameterDTO makeParam(String name, String type) {
        AccessMethodParameterDTO parameterDTO = new AccessMethodParameterDTO();
        parameterDTO.name = name;
        parameterDTO.type = type;
        return parameterDTO;
    }

    private List<AccessMethodDTO> generateAccessMethodsDescriptions(SensinactResource resource) {
        ArrayList<AccessMethodDTO> methods = new ArrayList<AccessMethodDTO>();
        if (resource.getResourceType() == ResourceType.ACTION) {
            AccessMethodDTO actMethod = new AccessMethodDTO();
            actMethod.name = "ACT";
            List actMethodArgumentsTypes = resource.getArguments();
            ArrayList<AccessMethodParameterDTO> actParams = new ArrayList<AccessMethodParameterDTO>(actMethodArgumentsTypes.size());
            for (Map.Entry entry : actMethodArgumentsTypes) {
                AccessMethodParameterDTO param = new AccessMethodParameterDTO();
                param.name = (String)entry.getKey();
                param.type = ((Class)entry.getValue()).getName();
                actParams.add(param);
            }
            actMethod.parameters = actParams;
            methods.add(actMethod);
        } else {
            AccessMethodDTO getMethod = new AccessMethodDTO();
            getMethod.name = "GET";
            getMethod.parameters = List.of(this.makeParam("attributeName", "string"));
            methods.add(getMethod);
            AccessMethodDTO subscriptionMethod = new AccessMethodDTO();
            subscriptionMethod.name = "SUBSCRIBE";
            subscriptionMethod.parameters = List.of(this.makeParam("topics", "array"), this.makeParam("isDataListener", "boolean"), this.makeParam("isMetadataListener", "boolean"), this.makeParam("isLifecycleListener", "boolean"), this.makeParam("isActionListener", "boolean"));
            methods.add(subscriptionMethod);
            AccessMethodDTO unsubscriptionMethod = new AccessMethodDTO();
            unsubscriptionMethod.name = "UNSUBSCRIBE";
            unsubscriptionMethod.parameters = List.of(this.makeParam("subscriptionId", "string"));
            methods.add(unsubscriptionMethod);
            if (resource.getValueType() == ValueType.MODIFIABLE) {
                AccessMethodDTO setMethod = new AccessMethodDTO();
                Class contentType = resource.getType();
                setMethod.name = "SET";
                setMethod.parameters = List.of(this.makeParam("value", contentType != null ? contentType.getName() : Object.class.getName()));
                methods.add(setMethod);
            }
        }
        return methods;
    }

    private List<MetadataDTO> generateMetadataDescriptions(SensinactResource resource, Map<String, Object> metadataMap) {
        List<MetadataDTO> result;
        if (metadataMap != null) {
            result = new ArrayList<MetadataDTO>(metadataMap.size());
            for (Map.Entry<String, Object> entry : metadataMap.entrySet()) {
                Object value = entry.getValue();
                MetadataDTO meta = new MetadataDTO();
                meta.name = entry.getKey();
                meta.value = value;
                if (value == null) continue;
                meta.type = value.getClass().getName();
            }
        } else {
            result = List.of();
        }
        return result;
    }

    private AbstractResultDTO describeProviders(SensiNactSession userSession, QueryDescribeDTO query) throws Exception {
        Collection<Object> providers;
        if (query.filter != null && !query.filter.isBlank()) {
            try {
                providers = this.executeFilter(query.filter, query.filterLanguage);
            }
            catch (StatusException e) {
                return e.toErrorResult();
            }
        } else {
            providers = userSession.filteredSnapshot(null);
        }
        ResultDescribeProvidersDTO result = new ResultDescribeProvidersDTO();
        result.statusCode = 200;
        result.providers = new ArrayList<CompleteProviderDescriptionDTO>(providers.size());
        for (ProviderSnapshot providerSnapshot : providers) {
            ((ResourceSnapshot)((ServiceSnapshot)providerSnapshot.getServices().get(0)).getResources().get(0)).getValue();
            CompleteProviderDescriptionDTO providerDto = new CompleteProviderDescriptionDTO();
            providerDto.name = providerSnapshot.getName();
            ServiceSnapshot adminSvc = null;
            for (ServiceSnapshot svcSnapshot : providerSnapshot.getServices()) {
                if (!"admin".equals(svcSnapshot.getName())) continue;
                adminSvc = svcSnapshot;
                break;
            }
            if (adminSvc != null) {
                for (ResourceSnapshot rcSnapshot : adminSvc.getResources()) {
                    switch (rcSnapshot.getName()) {
                        case "icon": {
                            TimedValue value;
                            if (!query.attrs.contains("icon") || (value = rcSnapshot.getValue()) == null) break;
                            providerDto.icon = (String)value.getValue();
                            break;
                        }
                        case "friendlyName": {
                            TimedValue value;
                            if (!query.attrs.contains("friendlyName") || (value = rcSnapshot.getValue()) == null) break;
                            providerDto.friendlyName = (String)value.getValue();
                            break;
                        }
                        case "location": {
                            TimedValue value;
                            if (!query.attrs.isEmpty() && !query.attrs.contains("location") || (value = rcSnapshot.getValue()) == null) break;
                            providerDto.location = (GeoJsonObject)value.getValue();
                            break;
                        }
                    }
                }
            }
            providerDto.services = providerSnapshot.getServices().stream().map(this::completeServiceDescription).collect(Collectors.toList());
            result.providers.add(providerDto);
        }
        return result;
    }

    private AbstractResultDTO describeProvider(SensiNactSession userSession, String providerId) throws Exception {
        ProviderDescription provider = userSession.describeProvider(providerId);
        if (provider == null) {
            return new ErrorResultDTO(404, "Unknown provider");
        }
        TypedResponse result = new TypedResponse(EResultType.DESCRIBE_PROVIDER);
        result.statusCode = 200;
        result.response = new ResponseDescribeProviderDTO();
        ((ResponseDescribeProviderDTO)result.response).name = provider.provider;
        ((ResponseDescribeProviderDTO)result.response).services = provider.services;
        return result;
    }

    private ResponseDescribeServiceDTO completeServiceDescription(ServiceSnapshot svcSnapshot) {
        ResponseDescribeServiceDTO svcDesc = new ResponseDescribeServiceDTO();
        svcDesc.name = svcSnapshot.getName();
        svcDesc.resources = new ArrayList<ShortResourceDescriptionDTO>(svcSnapshot.getResources().size());
        for (ResourceSnapshot rcSnapshot : svcSnapshot.getResources()) {
            ShortResourceDescriptionDTO rcDesc = new ShortResourceDescriptionDTO();
            rcDesc.name = rcSnapshot.getName();
            rcDesc.type = rcSnapshot.getResourceType();
            if (rcDesc.type != ResourceType.ACTION) {
                rcDesc.rws = EReadWriteMode.fromValueType(rcSnapshot.getValueType());
            }
            svcDesc.resources.add(rcDesc);
        }
        return svcDesc;
    }

    private AbstractResultDTO describeService(SensiNactSession userSession, final String providerId, final String serviceId) throws Exception {
        ServiceSnapshot svcSnapshot = (ServiceSnapshot)this.gatewayThread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<ServiceSnapshot>(){

            protected Promise<ServiceSnapshot> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory pf) {
                return pf.resolved((Object)twin.snapshotService(providerId, serviceId));
            }
        }).getValue();
        if (svcSnapshot == null) {
            return new ErrorResultDTO(404, "Service not found");
        }
        TypedResponse result = new TypedResponse(EResultType.DESCRIBE_SERVICE);
        result.statusCode = 200;
        result.response = this.completeServiceDescription(svcSnapshot);
        return result;
    }

    private AbstractResultDTO describeResource(SensiNactSession userSession, String providerId, String serviceId, String resourceId) throws Exception {
        return (AbstractResultDTO)this.gatewayThread.execute((AbstractSensinactCommand)new ResourceCommand<ResponseDescribeResourceDTO>(providerId, serviceId, resourceId){

            protected Promise<ResponseDescribeResourceDTO> call(SensinactResource resource, PromiseFactory pf) {
                ResponseDescribeResourceDTO dto = new ResponseDescribeResourceDTO();
                dto.name = resource.getName();
                dto.type = resource.getResourceType();
                dto.accessMethods = QueryHandler.this.generateAccessMethodsDescriptions(resource);
                return resource.getMetadataValues().then(metadata -> {
                    dto.attributes = QueryHandler.this.generateMetadataDescriptions(resource, (Map)metadata.getValue());
                    return pf.resolved((Object)dto);
                });
            }
        }).then(d -> {
            TypedResponse result = new TypedResponse(EResultType.DESCRIBE_RESOURCE);
            result.statusCode = 200;
            result.response = (ResponseDescribeResourceDTO)d.getValue();
            return Promises.resolved(result);
        }).fallbackTo(Promises.resolved((Object)new ErrorResultDTO(404, "Resource not set"))).getValue();
    }
}

