/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.virtual.temperature;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.southbound.virtual.temperature.VirtualTemperatureDto;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.promise.Promise;

public class VirtualTemperatureSensor {
    private final DataUpdate push;
    private final String name;
    private final Random random;
    private final long interval;
    private final double min;
    private final double max;
    private final AtomicBoolean active = new AtomicBoolean(true);

    VirtualTemperatureSensor(DataUpdate push, String name, Random random, long interval, double min, double max, GeoJsonObject location) throws Exception {
        this.push = push;
        this.name = name;
        this.random = random;
        this.interval = interval;
        this.min = min;
        this.max = max;
        GenericDto dto = new GenericDto();
        dto.model = "virtual.temperature";
        dto.provider = name;
        dto.service = "admin";
        dto.resource = "location";
        dto.value = location;
        push.pushUpdate((Object)dto).getValue();
        this.repeatedUpdate();
    }

    @Deactivate
    void stop() {
        this.active.set(false);
    }

    private Promise<Void> repeatedUpdate() {
        return this.update().delay(this.interval).then(p -> this.active.get() ? this.repeatedUpdate() : p);
    }

    Promise<Void> update() {
        VirtualTemperatureDto dto = new VirtualTemperatureDto();
        dto.provider = this.name;
        dto.temperature = this.min + (this.max - this.min) * this.random.nextDouble();
        return this.push.pushUpdate((Object)dto).map(x -> null);
    }
}

