/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.impl;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import jakarta.ws.rs.core.Application;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.rest.impl.AuthenticationFilter;
import org.eclipse.sensinact.northbound.rest.impl.ObjectMapperProvider;
import org.eclipse.sensinact.northbound.rest.impl.QueryHandlerProvider;
import org.eclipse.sensinact.northbound.rest.impl.RestNorthbound;
import org.eclipse.sensinact.northbound.rest.impl.SensinactSessionProvider;
import org.eclipse.sensinact.northbound.rest.impl.StatusCodeFilter;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsApplicationBase;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsName;

@Component(service={Application.class}, configurationPid={"sensinact.northbound.rest"})
@JakartarsName(value="sensinact-rest")
@JakartarsApplicationBase(value="/sensinact")
public class RestAccessApplication
extends Application {
    @Reference
    SensiNactSessionManager sessionManager;
    @Reference
    IQueryHandler queryHandler;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    final List<Authenticator> authenticators = new CopyOnWriteArrayList<Authenticator>();
    @Activate
    Config config;

    public Set<Class<?>> getClasses() {
        return Set.of(StatusCodeFilter.class, SensinactSessionProvider.class, QueryHandlerProvider.class, ObjectMapperProvider.class, JacksonJsonProvider.class, JacksonXmlBindJsonProvider.class, RestNorthbound.class, AuthenticationFilter.class);
    }

    public SensiNactSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Map<String, Object> getProperties() {
        return Map.of("session.manager", this.sessionManager, "query.handler", this.queryHandler, "authentication.providers", this.authenticators, "raw.anonymous.access", this.config.allow_anonymous());
    }

    static @interface Config {
        public boolean allow_anonymous() default false;
    }
}

