/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.metrics.impl;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.core.metrics.IMetricCounter;
import org.eclipse.sensinact.core.metrics.IMetricTimer;
import org.eclipse.sensinact.core.metrics.IMetricsGauge;
import org.eclipse.sensinact.core.metrics.IMetricsHistogram;
import org.eclipse.sensinact.core.metrics.IMetricsListener;
import org.eclipse.sensinact.core.metrics.IMetricsManager;
import org.eclipse.sensinact.core.metrics.IMetricsMultiGauge;
import org.eclipse.sensinact.core.metrics.impl.CallbackReporter;
import org.eclipse.sensinact.core.metrics.impl.Counter;
import org.eclipse.sensinact.core.metrics.impl.DummyTimer;
import org.eclipse.sensinact.core.metrics.impl.Histogram;
import org.eclipse.sensinact.core.metrics.impl.MetricsConfiguration;
import org.eclipse.sensinact.core.metrics.impl.MetricsTimer;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.converter.ConverterBuilder;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Rule;
import org.osgi.util.converter.TargetRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={IMetricsManager.class}, configurationPid={"sensinact.metrics"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class MetricsManager
implements IMetricsManager {
    private static final Logger logger = LoggerFactory.getLogger(IMetricsManager.class);
    static final String PID = "sensinact.metrics";
    private boolean isActive = true;
    private String metricsProvider;
    private int updateRate;
    private final Set<String> activeMetrics = new HashSet<String>();
    private MetricRegistry registry;
    private CallbackReporter callbackReporter;
    private boolean allowConsoleReporter;
    private ConsoleReporter consoleReporter;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, fieldOption=FieldOption.UPDATE, policy=ReferencePolicy.DYNAMIC)
    private final List<IMetricsListener> listener = new CopyOnWriteArrayList<IMetricsListener>();

    @Activate
    void activate(MetricsConfiguration config) {
        this.activeMetrics.clear();
        this.registry = new MetricRegistry();
        this.update(config);
    }

    @Modified
    void update(MetricsConfiguration config) {
        this.isActive = config.enabled();
        this.metricsProvider = config.provider_name();
        this.updateRate = config.metrics_rate() > 0 ? config.metrics_rate() : 10;
        this.activeMetrics.clear();
        this.activeMetrics.addAll(Arrays.asList(config.metrics_enabled()));
        this.allowConsoleReporter = config.console_enabled();
        if (this.isActive) {
            this.enableMetrics();
        } else {
            this.disableMetrics();
        }
    }

    @Deactivate
    void deactivate() {
        this.isActive = false;
        this.activeMetrics.clear();
        if (this.consoleReporter != null) {
            this.consoleReporter.stop();
            this.consoleReporter = null;
        }
        this.disableMetrics();
        if (this.registry != null) {
            for (String name : this.registry.getNames()) {
                this.registry.remove(name);
            }
            this.registry = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void registerGauge(IMetricsGauge gauge, Map<?, ?> properties) {
        String name = (String)properties.get("sensinact.metrics.gauge.name");
        if (name == null || name.isBlank()) {
            logger.warn("Gauge service registered without the {} property", (Object)"sensinact.metrics.gauge.name");
            return;
        }
        this.registerGauge(name, () -> ((IMetricsGauge)gauge).gauge());
    }

    void unregisterGauge(Map<?, ?> properties) {
        String name = (String)properties.get("sensinact.metrics.gauge.name");
        if (name != null && !name.isBlank()) {
            this.unregisterGauge(name);
        }
    }

    private List<String> extractMultigaugeNames(Object rawNames) {
        if (rawNames == null) {
            return List.of();
        }
        ConverterBuilder cb = Converters.newConverterBuilder();
        cb.rule((TargetRule)new Rule<String, String[]>(v -> (String[])Arrays.stream(v.split(",")).toArray(String[]::new)){});
        cb.errorHandler((o, e) -> new String[0]);
        return Arrays.asList((String[])cb.build().convert(rawNames).to(String[].class));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void registerGauges(IMetricsMultiGauge gauges, Map<String, Object> properties) {
        List<String> names = this.extractMultigaugeNames(properties.get("sensinact.metrics.multigauge.names"));
        if (names.isEmpty()) {
            logger.warn("Multigauge service registered without the {} property", (Object)"sensinact.metrics.multigauge.names");
            return;
        }
        for (String name : names) {
            this.registerGauge(name, () -> gauges.gauge(name));
        }
    }

    void unregisterGauges(Map<?, ?> properties) {
        List<String> names = this.extractMultigaugeNames(properties.get("sensinact.metrics.multigauge.names"));
        for (String name : names) {
            this.unregisterGauge(name);
        }
    }

    private <T> void registerGauge(final String name, final Callable<T> gaugeCallback) {
        if (this.registry != null && gaugeCallback != null) {
            this.registry.registerGauge(name, new Gauge<T>(){

                public T getValue() {
                    try {
                        return gaugeCallback.call();
                    }
                    catch (Exception e) {
                        logger.error("Error calling gauge {}: {}", new Object[]{name, e.getMessage(), e});
                        return null;
                    }
                }
            });
        }
    }

    private void unregisterGauge(String name) {
        if (this.registry != null) {
            this.registry.remove(name);
        }
    }

    private void reporterCallback(BulkGenericDto dtos) {
        for (IMetricsListener consumer : this.listener) {
            try {
                consumer.onMetricsReport(dtos);
            }
            catch (Throwable e) {
                logger.error("Error updating SensiNact metrics: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private boolean isEnabled(String name) {
        return this.isActive && this.registry != null && (this.activeMetrics.isEmpty() || this.activeMetrics.contains(name));
    }

    public void enableMetrics() {
        this.isActive = true;
        if (this.allowConsoleReporter) {
            if (this.consoleReporter != null) {
                this.consoleReporter.close();
                this.consoleReporter = null;
            }
            this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build();
            this.consoleReporter.start((long)this.updateRate, TimeUnit.SECONDS);
        } else if (this.consoleReporter != null) {
            this.consoleReporter.close();
            this.consoleReporter = null;
        }
        if (this.callbackReporter != null) {
            this.callbackReporter.close();
            this.callbackReporter = null;
        }
        if (this.callbackReporter == null) {
            this.callbackReporter = new CallbackReporter(this::reporterCallback, this.registry, this.metricsProvider);
            this.callbackReporter.start(this.updateRate, TimeUnit.SECONDS);
        }
    }

    public void disableMetrics() {
        this.isActive = false;
        if (this.consoleReporter != null) {
            this.consoleReporter.close();
            this.consoleReporter = null;
        }
        if (this.callbackReporter != null) {
            this.callbackReporter.close();
            this.callbackReporter = null;
        }
        this.clear();
    }

    public void clear() {
        HashSet toRemove = new HashSet(this.registry.getNames());
        toRemove.removeAll(this.registry.getGauges().keySet());
        this.registry.removeMatching((name, metric) -> toRemove.contains(name));
    }

    public void enableMetrics(String ... names) {
        if (names != null) {
            this.activeMetrics.addAll(Arrays.asList(names));
        }
    }

    public void disableMetrics(String ... names) {
        if (names != null) {
            this.activeMetrics.removeAll(Arrays.asList(names));
        }
    }

    public IMetricTimer withTimer(String name) {
        if (!this.isEnabled(name)) {
            return new DummyTimer(name);
        }
        return new MetricsTimer(this.registry, name);
    }

    public IMetricTimer withTimers(final String ... names) {
        final ArrayList<MetricsTimer> timers = new ArrayList<MetricsTimer>();
        for (String name : names) {
            if (!this.isEnabled(name)) continue;
            timers.add(new MetricsTimer(this.registry, name));
        }
        return new IMetricTimer(){

            public String getName() {
                return "[" + String.join((CharSequence)", ", names) + "]";
            }

            public void close() {
                for (IMetricTimer timer : timers) {
                    timer.close();
                }
            }
        };
    }

    public IMetricCounter getCounter(String name) {
        return new Counter(name, this.registry, this::isEnabled);
    }

    public IMetricsHistogram getHistogram(String name) {
        return new Histogram(name, this.registry, this::isEnabled);
    }
}

