/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.nexus.emf.compare;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.model.core.metadata.MetadataFactory;
import org.eclipse.sensinact.model.core.metadata.MetadataPackage;
import org.eclipse.sensinact.model.core.metadata.ResourceMetadata;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.DynamicProvider;
import org.eclipse.sensinact.model.core.provider.FeatureCustomMetadata;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.eclipse.sensinact.model.core.provider.impl.FeatureCustomMetadataImpl;
import org.eclipse.sensinact.model.core.provider.impl.ServiceMapImpl;

public class EMFCompareUtil {
    public static void compareAndSet(Provider incmming, Provider original, NotificationAccumulator accumulator) {
        if (incmming == null || original == null) {
            return;
        }
        if (incmming.eClass() != original.eClass()) {
            throw new IllegalArgumentException(String.format("The given incomming Provider %s is of type %s but should be of type %s", incmming.toString(), incmming.eClass().getName(), original.eClass().getName()));
        }
        EClass eClass = incmming.eClass();
        EMFUtil.streamAttributes(eClass).forEach(ea -> original.eSet((EStructuralFeature)ea, incmming.eGet((EStructuralFeature)ea)));
        eClass.getEAllReferences().stream().filter(er -> er.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(Predicate.not(ProviderPackage.Literals.PROVIDER__LINKED_PROVIDERS::equals)).filter(er -> !ProviderPackage.Literals.SERVICE.isSuperTypeOf(er.getEReferenceType())).filter(Predicate.not(ProviderPackage.Literals.DYNAMIC_PROVIDER__SERVICES::equals)).forEach(er -> original.eSet((EStructuralFeature)er, er.isContainment() ? EcoreUtil.copy((EObject)((EObject)incmming.eGet((EStructuralFeature)er))) : incmming.eGet((EStructuralFeature)er)));
        EMFCompareUtil.updateAdmin(incmming, original, accumulator);
        eClass.getEAllReferences().stream().filter(er -> er.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(Predicate.not(ProviderPackage.Literals.PROVIDER__LINKED_PROVIDERS::equals)).filter(Predicate.not(ProviderPackage.Literals.PROVIDER__ADMIN::equals)).filter(Predicate.not(ProviderPackage.Literals.DYNAMIC_PROVIDER__SERVICES::equals)).filter(er -> ProviderPackage.Literals.SERVICE.isSuperTypeOf(er.getEReferenceType())).forEach(er -> EMFCompareUtil.serviceUpdate(er, incmming, original, accumulator, Collections.emptyList()));
        if (incmming instanceof DynamicProvider) {
            EMFCompareUtil.servicesMapUpdate((DynamicProvider)incmming, (DynamicProvider)original, accumulator, Collections.emptyList());
        }
    }

    private static void updateAdmin(Provider incomming, Provider original, NotificationAccumulator accumulator) {
        Admin newService = incomming.getAdmin();
        if (newService != null) {
            EMFCompareUtil.serviceUpdate(ProviderPackage.Literals.PROVIDER__ADMIN, incomming, original, accumulator, List.of(ProviderPackage.Literals.ADMIN__MODEL, ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI));
        }
    }

    private static void serviceUpdate(EReference reference, Provider incomming, Provider original, NotificationAccumulator accumulator, List<EStructuralFeature> blackList) {
        Service newService = (Service)incomming.eGet((EStructuralFeature)reference);
        Service oldService = (Service)original.eGet((EStructuralFeature)reference);
        if (newService == null && oldService == null) {
            return;
        }
        if (newService != null && oldService == null) {
            Service copy = (Service)EcoreUtil.copy((EObject)newService);
            original.eSet((EStructuralFeature)reference, (Object)copy);
            EMFCompareUtil.notifyServiceAdd(original, copy, reference.getName(), accumulator);
        } else if (newService == null && oldService != null) {
            EMFCompareUtil.notifyServiceRemove(original, oldService, reference.getName(), accumulator);
            original.eUnset((EStructuralFeature)reference);
        } else {
            if (newService.eClass() != oldService.eClass()) {
                if (oldService.eClass().isSuperTypeOf(newService.eClass())) {
                    oldService = EMFCompareUtil.copyOldService(oldService, newService.eClass());
                    original.eSet((EStructuralFeature)reference, (Object)oldService);
                } else {
                    throw new RuntimeException("Merging Services of different Types is not possible." + newService.eClass().getName() + " must be a subtype of " + oldService.eClass().getName());
                }
            }
            EMFCompareUtil.mergeAndNotify(reference.getName(), newService, oldService, blackList, accumulator);
        }
    }

    private static void servicesMapUpdate(DynamicProvider incomming, DynamicProvider original, NotificationAccumulator accumulator, List<EStructuralFeature> blackList) {
        ArrayList toDelete = new ArrayList(original.getServices().keySet());
        ArrayList toAdd = new ArrayList(incomming.getServices().keySet());
        ArrayList<String> toUpdate = new ArrayList<String>();
        Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            String serviceName = (String)iterator.next();
            if (!toDelete.remove(serviceName)) continue;
            iterator.remove();
            toUpdate.add(serviceName);
        }
        for (String serviceName : toAdd) {
            Service copy = (Service)EcoreUtil.copy((EObject)((Service)incomming.getServices().get((Object)serviceName)));
            original.getServices().put((Object)serviceName, (Object)copy);
            EMFCompareUtil.notifyServiceAdd((Provider)original, copy, serviceName, accumulator);
        }
        for (String serviceName : toDelete) {
            Service oldService = (Service)original.getServices().removeKey((Object)serviceName);
            EMFCompareUtil.notifyServiceRemove((Provider)original, oldService, serviceName, accumulator);
        }
        for (String serviceName : toUpdate) {
            Service newService = (Service)incomming.getServices().get((Object)serviceName);
            Service oldService = (Service)original.getServices().get((Object)serviceName);
            if (newService.eClass() != oldService.eClass()) {
                if (oldService.eClass().isSuperTypeOf(newService.eClass())) {
                    oldService = EMFCompareUtil.copyOldService(oldService, newService.eClass());
                    original.getServices().put((Object)serviceName, (Object)oldService);
                } else {
                    throw new RuntimeException("Merging Services of different Types is not possible." + newService.eClass().getName() + " must be a subtype of " + oldService.eClass().getName());
                }
            }
            EMFCompareUtil.mergeAndNotify(serviceName, newService, oldService, blackList, accumulator);
        }
    }

    private static Service copyOldService(Service oldService, EClass eClass) {
        Service eObject = (Service)EcoreUtil.create((EClass)eClass);
        oldService.eClass().getEAllStructuralFeatures().forEach(e -> eObject.eSet(e, oldService.eGet(e)));
        return eObject;
    }

    private static void mergeAndNotify(String serviceName, Service newService, Service originalService, List<EStructuralFeature> blackList, NotificationAccumulator accumulator) {
        if (newService.eClass() != originalService.eClass()) {
            throw new UnsupportedOperationException("Merging Services of different Tyoes is not supported yet");
        }
        originalService.eClass().getEAllReferences().stream().filter(er -> er.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(Predicate.not(ProviderPackage.Literals.SERVICE__METADATA::equals)).filter(Predicate.not(blackList::contains)).forEach(er -> originalService.eSet((EStructuralFeature)er, er.isContainment() ? EcoreUtil.copy((EObject)((EObject)newService.eGet((EStructuralFeature)er))) : newService.eGet((EStructuralFeature)er)));
        originalService.eClass().getEAllAttributes().stream().filter(er -> er.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(Predicate.not(blackList::contains)).forEach(er -> EMFCompareUtil.notifyAttributeChange(er, serviceName, newService, originalService, accumulator));
    }

    private static void notifyAttributeChange(EAttribute resource, String serviceName, Service newService, Service originalService, NotificationAccumulator accumulator) {
        EObject container = originalService.eContainer();
        if (container instanceof ServiceMapImpl) {
            container = container.eContainer();
        }
        if (container instanceof Provider) {
            String packageUri = container.eClass().getEPackage().getNsURI();
            String modelName = EMFUtil.getModelName(container.eClass());
            String providerName = ((Provider)container).getId();
            Metadata originalMetadata = (Metadata)originalService.getMetadata().get((Object)resource);
            boolean isNew = !originalService.eIsSet((EStructuralFeature)resource);
            Object oldValue = originalService.eGet((EStructuralFeature)resource);
            Object newValue = newService.eGet((EStructuralFeature)resource);
            Instant previousTimestamp = null;
            Instant newTimestamp = EMFCompareUtil.getNewTimestampFromMetadata(resource, newService);
            if (originalMetadata != null) {
                previousTimestamp = originalMetadata.getTimestamp();
            }
            if (Objects.equals(oldValue, newValue) && Objects.equals(previousTimestamp, newTimestamp)) {
                return;
            }
            if (previousTimestamp != null && newTimestamp != null && previousTimestamp.isAfter(newTimestamp)) {
                return;
            }
            if (newTimestamp == null) {
                newTimestamp = Instant.now();
            }
            if (isNew) {
                accumulator.addResource(packageUri, modelName, providerName, serviceName, resource.getName());
            }
            Map<String, Object> oldMetaData = null;
            if (previousTimestamp != null && !previousTimestamp.equals(Instant.EPOCH)) {
                oldMetaData = EMFCompareUtil.extractMetadataMap(oldValue, originalMetadata, (ETypedElement)resource);
            }
            ResourceMetadata updatedMetadata = EMFCompareUtil.updateMetadata(resource, serviceName, newService, originalService, newTimestamp);
            originalService.eSet((EStructuralFeature)resource, newValue);
            accumulator.resourceValueUpdate(packageUri, modelName, providerName, serviceName, resource.getName(), resource.getEAttributeType().getInstanceClass(), oldValue, newValue, newTimestamp);
            Map<String, Object> newMetaData = EMFCompareUtil.extractMetadataMap(newValue, (Metadata)updatedMetadata, (ETypedElement)resource);
            accumulator.metadataValueUpdate(packageUri, modelName, providerName, serviceName, resource.getName(), oldMetaData, newMetaData, newTimestamp);
            if (newValue == null) {
                accumulator.removeResource(packageUri, modelName, providerName, serviceName, resource.getName());
            }
        }
    }

    public static Map<String, Object> extractMetadataMap(Object value, Metadata updatedMetadata, ETypedElement feature) {
        Map<String, Object> newMetaData = EMFUtil.toMetadataAttributesToMap(updatedMetadata, feature);
        newMetaData.put("value", value);
        return newMetaData;
    }

    private static ResourceMetadata updateMetadata(EAttribute resource, String serviceName, Service newService, Service originalService, Instant newTimestamp) {
        ResourceMetadata resourceMetadata = EMFCompareUtil.checkMetadata(originalService, resource);
        resourceMetadata.setTimestamp(newTimestamp);
        Metadata update = (Metadata)newService.getMetadata().get((Object)resource);
        if (update != null && update.eIsSet((EStructuralFeature)ProviderPackage.Literals.METADATA__EXTRA)) {
            EMFCompareUtil.updateExtraMetadata((EList<FeatureCustomMetadata>)update.getExtra(), (EList<FeatureCustomMetadata>)resourceMetadata.getExtra(), newTimestamp);
        }
        return resourceMetadata;
    }

    private static void updateExtraMetadata(EList<FeatureCustomMetadata> extraNew, EList<FeatureCustomMetadata> extraOriginal, Instant newTimestamp) {
        if (extraNew.isEmpty() && extraOriginal.isEmpty()) {
            return;
        }
        ArrayList<FeatureCustomMetadata> toRemove = new ArrayList<FeatureCustomMetadata>((Collection<FeatureCustomMetadata>)extraOriginal);
        extraNew.forEach(fcm -> {
            Instant timestamp;
            FeatureCustomMetadata original = EMFCompareUtil.removeByName(fcm.getName(), toRemove);
            Instant instant = timestamp = fcm.getTimestamp() == null ? newTimestamp : fcm.getTimestamp();
            if (original == null) {
                FeatureCustomMetadata copy = (FeatureCustomMetadata)EcoreUtil.copy((EObject)fcm);
                if (copy.getTimestamp() == null) {
                    copy.setTimestamp(newTimestamp);
                }
                extraOriginal.add((Object)copy);
            } else if (original.getTimestamp().plusMillis(1L).isBefore(timestamp)) {
                original.setValue(fcm.getValue());
                original.getTimestamp();
            }
        });
        extraOriginal.removeAll(toRemove);
    }

    private static FeatureCustomMetadata removeByName(String name, List<FeatureCustomMetadata> compareList) {
        Iterator<FeatureCustomMetadata> iterator = compareList.iterator();
        while (iterator.hasNext()) {
            FeatureCustomMetadata featureCustomMetadata = iterator.next();
            if (!name.equals(featureCustomMetadata.getName())) continue;
            iterator.remove();
            return featureCustomMetadata;
        }
        return null;
    }

    private static Instant getNewTimestampFromMetadata(EAttribute resource, Service service) {
        Metadata metadata = (Metadata)service.getMetadata().get((Object)resource);
        if (metadata != null && metadata.getTimestamp() != null) {
            return metadata.getTimestamp();
        }
        return null;
    }

    private static void notifyServiceAdd(Provider container, Service service, String serviceName, NotificationAccumulator accumulator) {
        String packageUri = container.eClass().getEPackage().getNsURI();
        String model = EMFUtil.getModelName(container.eClass());
        String providerName = container.getId();
        accumulator.addService(packageUri, model, providerName, serviceName);
        EMFUtil.streamAttributes(service.eClass()).filter(ea -> service.eIsSet((EStructuralFeature)ea)).forEach(ea -> {
            EMFCompareUtil.checkMetadata(service, ea);
            Metadata metadata = (Metadata)service.getMetadata().get(ea);
            accumulator.addResource(packageUri, model, providerName, serviceName, ea.getName());
            accumulator.resourceValueUpdate(packageUri, model, providerName, serviceName, ea.getName(), ea.getEAttributeType().getInstanceClass(), null, service.eGet((EStructuralFeature)ea), metadata.getTimestamp());
            Map<String, Object> newMetaData = EMFUtil.toEObjectAttributesToMap((EObject)metadata, true, (List<EStructuralFeature>)MetadataPackage.Literals.NEXUS_METADATA.getEStructuralFeatures(), null, null);
            newMetaData.put("value", service.eGet((EStructuralFeature)ea));
            accumulator.metadataValueUpdate(packageUri, model, providerName, serviceName, ea.getName(), null, newMetaData, metadata.getTimestamp());
        });
    }

    private static void notifyServiceRemove(Provider container, Service value, String serviceName, NotificationAccumulator accumulator) {
        String packageUri = container.eClass().getEPackage().getNsURI();
        String model = EMFUtil.getModelName(container.eClass());
        String providerName = container.getId();
        EMFUtil.streamAttributes(value.eClass()).filter(ea -> value.eIsSet((EStructuralFeature)ea)).forEach(ea -> {
            accumulator.resourceValueUpdate(packageUri, model, providerName, serviceName, ea.getName(), ea.getEAttributeType().getInstanceClass(), null, null, Instant.now());
            accumulator.removeResource(packageUri, model, providerName, serviceName, ea.getName());
        });
        accumulator.removeService(packageUri, model, providerName, serviceName);
    }

    protected static ResourceMetadata checkMetadata(Service service, EAttribute attribute) {
        ResourceMetadata result = null;
        if (!service.getMetadata().containsKey((Object)attribute)) {
            result = MetadataFactory.eINSTANCE.createResourceMetadata();
            result.setTimestamp(Instant.now());
            result.setOriginalName(attribute.getName());
            service.getMetadata().put((Object)attribute, (Object)result);
        } else {
            Metadata metadata = (Metadata)service.getMetadata().get((Object)attribute);
            if (metadata.eClass() == ProviderPackage.Literals.METADATA) {
                result = MetadataFactory.eINSTANCE.createResourceMetadata();
                result.setTimestamp(metadata.getTimestamp() == null ? Instant.now() : metadata.getTimestamp());
                result.setOriginalName(attribute.getName());
                ResourceMetadata curMetadata = result;
                metadata.getExtra().stream().map(FeatureCustomMetadataImpl.class::cast).map(EcoreUtil::copy).map(fcm -> {
                    if (fcm.getTimestamp() == null) {
                        fcm.setTimestamp(Instant.now());
                    }
                    EMFCompareUtil.removeByName(fcm.getName(), (List<FeatureCustomMetadata>)curMetadata.getExtra());
                    return fcm;
                }).forEach(arg_0 -> result.getExtra().add(arg_0));
                service.getMetadata().put((Object)attribute, (Object)result);
            } else {
                result = (ResourceMetadata)metadata;
            }
        }
        return result;
    }
}

