/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.NotFoundException;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.PropertyMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SelectMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorThingsMqttException;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DatastreamMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DatastreamsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.FeatureOfInterestMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.FeaturesOfInterestMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.HistoricalLocationMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.HistoricalLocationsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.LocationMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.LocationsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ObservationMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ObservationsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ObservedPropertiesMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ObservedPropertyMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.SensorMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.SensorsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ThingMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ThingsMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.NameDescription;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SensorthingsMapper<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SensorthingsMapper.class);
    private static final Set<String> COLLECTIONS = Set.of("Things", "Locations", "HistoricalLocations", "Datastreams", "Sensors", "Observations", "ObservedProperties", "FeaturesOfInterest");
    private static final Pattern ENTITY_PATH = Pattern.compile("([\\w~]+)\\(([\\w~]+)\\)");
    private final String topicFilter;
    private final GatewayThread thread;
    protected final ObjectMapper jsonMapper;

    protected SensorthingsMapper(String topicFilter, ObjectMapper mapper, GatewayThread gateway) {
        this.topicFilter = topicFilter;
        this.jsonMapper = mapper;
        this.thread = gateway;
    }

    public Promise<Stream<T>> toPayload(AbstractResourceNotification notification) {
        if (notification instanceof ResourceDataNotification) {
            return this.toPayload((ResourceDataNotification)notification).filter(Objects::nonNull);
        }
        if (notification instanceof LifecycleNotification) {
            return this.toPayload((LifecycleNotification)notification).filter(Objects::nonNull);
        }
        if (notification instanceof ResourceMetaDataNotification) {
            return this.toPayload((ResourceMetaDataNotification)notification).filter(Objects::nonNull);
        }
        LOG.error("Unknown notification type {}", notification.getClass());
        return this.emptyStream();
    }

    protected Promise<Stream<T>> toPayload(LifecycleNotification lifecycleNotification) {
        return this.emptyStream();
    }

    protected Promise<Stream<T>> toPayload(ResourceDataNotification dataNotification) {
        return this.emptyStream();
    }

    protected Promise<Stream<T>> toPayload(ResourceMetaDataNotification metadataNotification) {
        return this.emptyStream();
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    protected abstract Class<T> getPayloadType();

    protected final Promise<Stream<T>> emptyStream() {
        return this.thread.getPromiseFactory().resolved(Stream.empty());
    }

    protected Promise<ProviderSnapshot> getProvider(final String providerName) {
        try {
            return this.thread.execute((AbstractSensinactCommand)new AbstractTwinCommand<ProviderSnapshot>(){

                protected Promise<ProviderSnapshot> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                    List snapshots = twin.filteredSnapshot(null, p -> p.getName().equals(providerName), null, null);
                    if (snapshots.isEmpty()) {
                        return pf.failed((Throwable)new NotFoundException(providerName));
                    }
                    return pf.resolved((Object)((ProviderSnapshot)snapshots.get(0)));
                }
            }).recoverWith(p -> {
                PromiseFactory pf = this.thread.getPromiseFactory();
                Throwable cause = p.getFailure();
                if (cause instanceof SensorThingsMqttException) {
                    return pf.failed(cause);
                }
                return pf.failed((Throwable)new SensorThingsMqttException("Error querying SensiNact", cause));
            });
        }
        catch (Exception e) {
            return this.thread.getPromiseFactory().failed((Throwable)new SensorThingsMqttException("Interrupted while querying SensiNact", e));
        }
    }

    protected Promise<ResourceSnapshot> getResource(String providerName, String serviceName, String resourceName) {
        Promise<ProviderSnapshot> provider = this.getProvider(providerName);
        return provider.map(p -> {
            for (ServiceSnapshot serviceSnapshot : p.getServices()) {
                if (!serviceSnapshot.getName().equals(serviceName)) continue;
                for (ResourceSnapshot resourceSnapshot : serviceSnapshot.getResources()) {
                    if (!resourceSnapshot.getName().equals(resourceName)) continue;
                    return resourceSnapshot;
                }
            }
            throw new NotFoundException(String.join((CharSequence)"~", providerName, serviceName, resourceName));
        });
    }

    protected Promise<Stream<T>> wrap(T value) {
        return this.thread.getPromiseFactory().resolved(Optional.ofNullable(value).stream());
    }

    protected Promise<Stream<T>> decorate(Promise<T> promise) {
        return promise.map(Stream::of).onFailure(t -> LOG.warn("An error occurred executing mapper {}", (Object)this.getClass().getSimpleName(), t)).recoverWith(x -> this.emptyStream());
    }

    protected <R> Promise<Stream<R>> mapProvider(Promise<ProviderSnapshot> p, Function<Promise<ResourceSnapshot>, Promise<Stream<R>>> conversion) {
        PromiseFactory pf = this.thread.getPromiseFactory();
        Promise sensors = p.flatMap(ps -> (Promise)this.getResourceSnapshots((ProviderSnapshot)ps).map(r -> (Promise)conversion.apply(pf.resolved(r))).collect(pf.toPromise()));
        return sensors.map(l -> l.stream().flatMap(Function.identity()));
    }

    private Stream<ResourceSnapshot> getResourceSnapshots(ProviderSnapshot ps) {
        return ps.getServices().stream().flatMap(s -> s.getResources().stream());
    }

    public static SensorthingsMapper<?> create(String topicFilter, ObjectMapper jsonMapper, GatewayThread thread) {
        String[] segments = topicFilter.split("/");
        if (!"v1.1".equals(segments[0])) {
            LOG.warn("The topic filter {} is not for the v1.1 API", (Object)topicFilter);
            return new NullMapper(topicFilter, jsonMapper, thread);
        }
        String selectFilter = null;
        int idx = segments[segments.length - 1].indexOf("?$select=");
        if (idx != -1) {
            selectFilter = segments[segments.length - 1].substring(idx + 9);
            segments[segments.length - 1] = segments[segments.length - 1].substring(0, idx);
        }
        SensorthingsMapper mapper = null;
        if (segments.length == 2) {
            if (COLLECTIONS.contains(segments[1])) {
                try {
                    mapper = SensorthingsMapper.getCollectionMapper(topicFilter, segments[1], jsonMapper, thread);
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn("The topic filter {} is not valid for the v1.1 API as it refers to an unknown collection type", (Object)topicFilter, (Object)iae);
                }
            } else {
                Matcher matcher = ENTITY_PATH.matcher(segments[1]);
                if (matcher.matches()) {
                    try {
                        mapper = SensorthingsMapper.getEntityMapper(topicFilter, matcher.group(1), matcher.group(2), jsonMapper, thread);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.warn("The topic filter {} is not valid for the v1.1 API as it refers to an unknown entity type", (Object)topicFilter, (Object)iae);
                    }
                } else {
                    LOG.warn("The topic filter {} is not valid for the v1.1 API as it does not select a single entity", (Object)topicFilter);
                }
            }
        } else if (segments.length == 3) {
            Matcher matcher = ENTITY_PATH.matcher(segments[1]);
            if (matcher.matches()) {
                mapper = COLLECTIONS.contains(segments[2]) ? SensorthingsMapper.getEntitySetMapper(topicFilter, segments[2], matcher.group(1), matcher.group(2), jsonMapper, thread) : SensorthingsMapper.getPropertyMapper(topicFilter, segments[2], matcher.group(1), matcher.group(2), jsonMapper, thread);
            } else {
                LOG.warn("The topic filter {} is not valid for the v1.1 API as it does not select a single entity", (Object)topicFilter);
            }
        } else {
            LOG.warn("The topic filter {} is not valid for the v1.1 API as it has the wrong number of segments", (Object)topicFilter);
        }
        if (mapper == null) {
            mapper = new NullMapper(topicFilter, jsonMapper, thread);
        }
        if (selectFilter != null) {
            mapper = new SelectMapper(topicFilter, selectFilter, mapper, jsonMapper, thread);
        }
        return mapper;
    }

    private static SensorthingsMapper<?> getCollectionMapper(String topicFilter, String entity, ObjectMapper mapper, GatewayThread thread) {
        switch (entity) {
            case "Things": {
                return new ThingsMapper(topicFilter, mapper, thread);
            }
            case "Locations": {
                return new LocationsMapper(topicFilter, mapper, thread);
            }
            case "HistoricalLocations": {
                return new HistoricalLocationsMapper(topicFilter, mapper, thread);
            }
            case "Datastreams": {
                return new DatastreamsMapper(topicFilter, mapper, thread);
            }
            case "Sensors": {
                return new SensorsMapper(topicFilter, mapper, thread);
            }
            case "Observations": {
                return new ObservationsMapper(topicFilter, mapper, thread);
            }
            case "ObservedProperties": {
                return new ObservedPropertiesMapper(topicFilter, mapper, thread);
            }
            case "FeaturesOfInterest": {
                return new FeaturesOfInterestMapper(topicFilter, mapper, thread);
            }
        }
        LOG.warn("The collection type {} is not recognised", (Object)entity);
        return null;
    }

    private static SensorthingsMapper<?> getEntityMapper(String topicFilter, String entity, String id, ObjectMapper mapper, GatewayThread thread) {
        switch (entity) {
            case "Things": {
                return new ThingMapper(topicFilter, id, mapper, thread);
            }
            case "Locations": {
                return new LocationMapper(topicFilter, id, mapper, thread);
            }
            case "HistoricalLocations": {
                return new HistoricalLocationMapper(topicFilter, id, mapper, thread);
            }
            case "Datastreams": {
                return new DatastreamMapper(topicFilter, id, mapper, thread);
            }
            case "Sensors": {
                return new SensorMapper(topicFilter, id, mapper, thread);
            }
            case "Observations": {
                return new ObservationMapper(topicFilter, id, mapper, thread);
            }
            case "ObservedProperties": {
                return new ObservedPropertyMapper(topicFilter, id, mapper, thread);
            }
            case "FeaturesOfInterest": {
                return new FeatureOfInterestMapper(topicFilter, id, mapper, thread);
            }
        }
        LOG.warn("The entity type {} is not recognised", (Object)entity);
        return null;
    }

    private static SensorthingsMapper<?> getEntitySetMapper(String topicFilter, String collection, String parentType, String parentId, ObjectMapper mapper, GatewayThread thread) {
        switch (collection) {
            case "Things": {
                return SensorthingsMapper.getThingsSubCollection(topicFilter, parentType, parentId, mapper, thread);
            }
            case "Locations": {
                return SensorthingsMapper.getLocationsSubCollection(topicFilter, parentType, parentId, mapper, thread);
            }
            case "HistoricalLocations": {
                return SensorthingsMapper.getHistoricalLocationsSubCollection(topicFilter, parentType, parentId, mapper, thread);
            }
            case "Datastreams": {
                return SensorthingsMapper.getDatastreamsSubCollection(topicFilter, parentType, parentId, mapper, thread);
            }
            case "Observations": {
                return SensorthingsMapper.getObservationsSubCollection(topicFilter, parentType, parentId, mapper, thread);
            }
            case "Sensors": 
            case "ObservedProperties": 
            case "FeaturesOfInterest": {
                LOG.warn("The collection type {} is not a sub collection of any recognised type", (Object)collection);
                return null;
            }
        }
        LOG.warn("The collection type {} is not recognised", (Object)collection);
        return null;
    }

    private static SensorthingsMapper<?> getThingsSubCollection(String topicFilter, String parentType, String parentId, ObjectMapper mapper, GatewayThread thread) {
        if ("Locations".equals(parentType)) {
            return new ThingMapper(topicFilter, parentId.split("~")[0], mapper, thread);
        }
        LOG.warn("The entity type {} does not contain a set of Things", (Object)parentType);
        return null;
    }

    private static SensorthingsMapper<?> getLocationsSubCollection(String topicFilter, String parentType, String parentId, ObjectMapper mapper, GatewayThread thread) {
        if ("Things".equals(parentType) || "HistoricalLocations".equals(parentType)) {
            return new LocationMapper(topicFilter, parentId, mapper, thread);
        }
        LOG.warn("The entity type {} does not contain a set of Locations", (Object)parentType);
        return null;
    }

    private static SensorthingsMapper<?> getHistoricalLocationsSubCollection(String topicFilter, String parentType, String parentId, ObjectMapper mapper, GatewayThread thread) {
        if ("Locations".equals(parentType)) {
            return new HistoricalLocationMapper(topicFilter, parentId.split("~")[0], mapper, thread);
        }
        LOG.warn("The entity type {} does not contain a set of HistoricalLocations", (Object)parentType);
        return null;
    }

    private static SensorthingsMapper<?> getDatastreamsSubCollection(String topicFilter, String parentType, final String parentId, ObjectMapper mapper, GatewayThread thread) {
        if ("Things".equals(parentType)) {
            return new DatastreamsMapper(topicFilter, mapper, thread){

                @Override
                public Promise<Stream<Datastream>> toPayload(AbstractResourceNotification notification) {
                    return parentId.equals(notification.provider) ? super.toPayload(notification) : this.emptyStream();
                }
            };
        }
        if ("Sensors".equals(parentType) || "ObservedProperties".equals(parentType)) {
            return new DatastreamMapper(topicFilter, parentId, mapper, thread);
        }
        LOG.warn("The entity type {} does not contain a set of Datastreams", (Object)parentType);
        return null;
    }

    private static SensorthingsMapper<?> getObservationsSubCollection(String topicFilter, String parentType, String parentId, ObjectMapper mapper, GatewayThread thread) {
        if ("Datastreams".equals(parentType) || "FeaturesOfInterest".equals(parentType)) {
            return new ObservationMapper(topicFilter, parentId, mapper, thread);
        }
        LOG.warn("The entity type {} does not contain a set of Observations", (Object)parentType);
        return null;
    }

    private static SensorthingsMapper<?> getPropertyMapper(String topicFilter, String property, String parentType, String parentId, ObjectMapper mapper, GatewayThread thread) {
        SensorthingsMapper<?> parent = SensorthingsMapper.getEntityMapper(topicFilter, parentType, parentId, mapper, thread);
        switch (property) {
            case "name": {
                return Thing.class.equals(parent.getPayloadType()) ? SensorthingsMapper.getPropertyMapper(NameDescription.class::isAssignableFrom, property, null, "admin", "friendlyName", parent, mapper, thread) : SensorthingsMapper.getPropertyMapper(NameDescription.class::isAssignableFrom, property, null, null, null, parent, mapper, thread);
            }
            case "description": {
                return SensorthingsMapper.getPropertyMapper(NameDescription.class::isAssignableFrom, property, null, "admin", "description", parent, mapper, thread);
            }
            case "unitOfMeasurement": {
                return SensorthingsMapper.getPropertyMapper(Datastream.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "observedArea": {
                return SensorthingsMapper.getPropertyMapper(Datastream.class::equals, property, null, "admin", "location", parent, mapper, thread);
            }
            case "resultTime": 
            case "phenomenonTime": {
                if (Datastream.class.equals(parent.getPayloadType())) {
                    return null;
                }
                return SensorthingsMapper.getPropertyMapper(Observation.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "properties": {
                return SensorthingsMapper.getPropertyMapper(Set.of(Datastream.class, ObservedProperty.class, Sensor.class, Thing.class)::contains, property, null, null, null, parent, mapper, thread);
            }
            case "feature": {
                return SensorthingsMapper.getPropertyMapper(FeatureOfInterest.class::equals, property, null, "admin", "location", parent, mapper, thread);
            }
            case "time": {
                return SensorthingsMapper.getPropertyMapper(HistoricalLocation.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "encodingType": {
                if (Location.class.equals(parent.getPayloadType())) {
                    return null;
                }
                return SensorthingsMapper.getPropertyMapper(Sensor.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "location": {
                return SensorthingsMapper.getPropertyMapper(Location.class::equals, property, null, "admin", "location", parent, mapper, thread);
            }
            case "result": {
                return SensorthingsMapper.getPropertyMapper(Observation.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "definition": {
                return SensorthingsMapper.getPropertyMapper(ObservedProperty.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "metadata": {
                return SensorthingsMapper.getPropertyMapper(Sensor.class::equals, property, null, null, null, parent, mapper, thread);
            }
            case "observationType": 
            case "resultQuality": 
            case "validTime": 
            case "parameters": {
                return null;
            }
        }
        LOG.warn("The property {} is not recognised", (Object)property);
        return null;
    }

    private static SensorthingsMapper<?> getPropertyMapper(Predicate<Class<?>> valid, String property, String provider, String service, String resource, SensorthingsMapper<?> parent, ObjectMapper mapper, GatewayThread thread) {
        if (valid.test(parent.getPayloadType())) {
            return new PropertyMapper(parent.getTopicFilter(), property, provider, service, resource, parent, mapper, thread);
        }
        throw new IllegalArgumentException("The property " + property + " from filter " + parent.getTopicFilter() + " cannot be found in the target object");
    }

    private static class NullMapper
    extends SensorthingsMapper<Object> {
        public NullMapper(String topic, ObjectMapper mapper, GatewayThread thread) {
            super(topic, mapper, thread);
        }

        @Override
        public Promise<Stream<Object>> toPayload(ResourceDataNotification notification) {
            return this.emptyStream();
        }

        @Override
        protected Class<Object> getPayloadType() {
            return Object.class;
        }
    }
}

