/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.metrics.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;

public class CallbackReporter
extends ScheduledReporter {
    private final String modelName;
    private final String providerName;
    private final Consumer<BulkGenericDto> callback;

    protected CallbackReporter(Consumer<BulkGenericDto> updateCallback, MetricRegistry registry, String providerName) {
        this(updateCallback, registry, providerName, providerName, MetricFilter.ALL);
    }

    protected CallbackReporter(Consumer<BulkGenericDto> updateCallback, MetricRegistry registry, String providerName, String modelName) {
        this(updateCallback, registry, providerName, modelName, MetricFilter.ALL);
    }

    protected CallbackReporter(Consumer<BulkGenericDto> updateCallback, MetricRegistry registry, String providerName, String modelName, MetricFilter filter) {
        super(registry, providerName, filter == null ? MetricFilter.ALL : filter, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.providerName = providerName;
        this.modelName = modelName != null ? modelName : providerName;
        this.callback = updateCallback;
    }

    private String normalizeName(String resource) {
        return resource.replaceAll("\\.", "-");
    }

    private GenericDto makeMetricsDto(Instant time, String resource, Object value) {
        GenericDto dto = new GenericDto();
        dto.timestamp = time;
        dto.model = this.modelName;
        dto.provider = this.providerName;
        if (resource.contains(".")) {
            int dotPosition = resource.indexOf(46);
            dto.service = this.normalizeName(resource.substring(0, dotPosition));
            dto.resource = this.normalizeName(resource.substring(dotPosition + 1));
        } else {
            dto.service = "metrics";
            dto.resource = this.normalizeName(resource);
        }
        dto.value = value;
        dto.type = value.getClass();
        return dto;
    }

    private GenericDto makeCountDto(Instant time, String rcPrefix, Counting counting) {
        return this.makeMetricsDto(time, rcPrefix + "-count", counting.getCount());
    }

    private List<GenericDto> makeMeteredDtos(Instant time, String rcPrefix, Metered metered) {
        ArrayList<GenericDto> dtos = new ArrayList<GenericDto>();
        dtos.add(this.makeCountDto(time, rcPrefix, (Counting)metered));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-mean-rate", metered.getMeanRate()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-1min-rate", metered.getOneMinuteRate()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-5min-rate", metered.getFiveMinuteRate()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-15min-rate", metered.getFifteenMinuteRate()));
        return dtos;
    }

    private List<GenericDto> makeSnapshotDtos(Instant time, String rcPrefix, Snapshot snapshot) {
        ArrayList<GenericDto> dtos = new ArrayList<GenericDto>();
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-min", snapshot.getMin()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-max", snapshot.getMax()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-mean", snapshot.getMean()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-stddev", snapshot.getStdDev()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-p50", snapshot.getMedian()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-p75", snapshot.get75thPercentile()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-p95", snapshot.get95thPercentile()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-p98", snapshot.get98thPercentile()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-p99", snapshot.get99thPercentile()));
        dtos.add(this.makeMetricsDto(time, rcPrefix + "-p99_9", snapshot.get999thPercentile()));
        return dtos;
    }

    private void addGlobalStats(Instant time, String resource, List<GenericDto> dtos) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        for (GenericDto dto : dtos) {
            String key = dto.resource.substring(dto.resource.lastIndexOf("-") + 1);
            stats.put(key, dto.value);
        }
        dtos.add(this.makeMetricsDto(time, resource, stats));
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        String name;
        Instant updateTime = Instant.now();
        ArrayList<GenericDto> dtos = new ArrayList<GenericDto>();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            dtos.add(this.makeMetricsDto(updateTime, entry.getKey(), entry.getValue().getValue()));
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            dtos.add(this.makeMetricsDto(updateTime, entry.getKey(), ((Counter)entry.getValue()).getCount()));
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            name = entry.getKey();
            ArrayList<GenericDto> meterDtos = new ArrayList<GenericDto>();
            meterDtos.addAll(this.makeMeteredDtos(updateTime, name, (Metered)entry.getValue()));
            this.addGlobalStats(updateTime, name, meterDtos);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            name = entry.getKey();
            Histogram histogram = (Histogram)entry.getValue();
            ArrayList<GenericDto> histogramDtos = new ArrayList<GenericDto>();
            histogramDtos.add(this.makeCountDto(updateTime, name, (Counting)histogram));
            histogramDtos.addAll(this.makeSnapshotDtos(updateTime, name, histogram.getSnapshot()));
            this.addGlobalStats(updateTime, name, histogramDtos);
            dtos.addAll(histogramDtos);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            name = entry.getKey();
            Timer timer = (Timer)entry.getValue();
            ArrayList<GenericDto> timerDtos = new ArrayList<GenericDto>();
            timerDtos.addAll(this.makeMeteredDtos(updateTime, name, (Metered)timer));
            timerDtos.addAll(this.makeSnapshotDtos(updateTime, name, timer.getSnapshot()));
            this.addGlobalStats(updateTime, name, timerDtos);
            dtos.addAll(timerDtos);
        }
        BulkGenericDto bulk = new BulkGenericDto();
        bulk.dtos = dtos;
        this.callback.accept(bulk);
    }
}

