/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.twin.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.sensinact.core.command.GetLevel;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFService;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.model.impl.ResourceImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.TimedValueImpl;
import org.eclipse.sensinact.model.core.metadata.ResourceAttribute;
import org.eclipse.sensinact.model.core.metadata.ResourceMetadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.Service;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class SensinactResourceImpl
extends CommandScopedImpl
implements SensinactResource {
    private final SensinactEMFService svc;
    private final Provider provider;
    private final String serviceName;
    private final ETypedElement resource;
    private final Class<?> type;
    private final ModelNexus modelNexus;
    private final PromiseFactory promiseFactory;

    public SensinactResourceImpl(AtomicBoolean active, SensinactEMFService svc, Provider provider, String serviceName, ETypedElement resource, Class<?> type, ModelNexus nexusImpl, PromiseFactory promiseFactory) {
        super(active);
        this.svc = svc;
        this.provider = provider;
        this.serviceName = serviceName;
        this.resource = resource;
        this.type = type;
        this.modelNexus = nexusImpl;
        this.promiseFactory = promiseFactory;
    }

    public Class<?> getType() {
        this.checkValid();
        return this.type;
    }

    public ValueType getValueType() {
        this.checkValid();
        return ResourceImpl.findValueType(this.resource);
    }

    public ResourceType getResourceType() {
        this.checkValid();
        return ResourceImpl.findResourceType(this.resource);
    }

    public List<Map.Entry<String, Class<?>>> getArguments() {
        this.checkValid();
        if (this.getResourceType() != ResourceType.ACTION) {
            throw new IllegalArgumentException("This is not an action resource");
        }
        return ResourceImpl.findActionParameters((EOperation)this.resource);
    }

    public String getName() {
        this.checkValid();
        return this.resource.getName();
    }

    private <T> TimedValue<T> getValueFromTwin(Class<T> type) {
        Instant currentTimestamp;
        Object currentValue;
        Service svc = this.provider.getService(this.serviceName);
        if (svc != null) {
            Object rawValue = svc.eGet((EStructuralFeature)((EAttribute)this.resource));
            currentValue = rawValue != null && type.isAssignableFrom(rawValue.getClass()) ? type.cast(rawValue) : null;
            ResourceMetadata metadata = (ResourceMetadata)svc.getMetadata().get((Object)this.resource);
            currentTimestamp = metadata != null ? metadata.getTimestamp() : null;
        } else {
            currentValue = null;
            currentTimestamp = null;
        }
        return new TimedValueImpl<Object>(currentValue, currentTimestamp);
    }

    public <T> Promise<Void> setValue(T value, Instant timestamp) {
        this.checkValid();
        if (this.getResourceType() == ResourceType.ACTION) {
            return this.promiseFactory.failed((Throwable)new IllegalArgumentException("This is an action resource"));
        }
        try {
            boolean hasExternalSetter;
            if (this.resource instanceof ResourceAttribute) {
                ResourceAttribute rc = (ResourceAttribute)this.resource;
                hasExternalSetter = rc.isExternalSet();
            } else {
                hasExternalSetter = false;
            }
            if (hasExternalSetter) {
                TimedValue<?> cachedValue = this.getValueFromTwin(this.type);
                TimedValueImpl<T> newValue = new TimedValueImpl<T>(value, timestamp);
                return this.modelNexus.pushValue(this.provider, this.serviceName, this.resource, this.type, cachedValue, newValue).map(x -> null);
            }
            this.modelNexus.handleDataUpdate(this.provider, this.serviceName, this.svc.getServiceEClass(), (EStructuralFeature)this.resource, value, timestamp);
            return this.promiseFactory.resolved(null);
        }
        catch (Exception e) {
            return this.promiseFactory.failed((Throwable)e);
        }
    }

    public <T> Promise<TimedValue<T>> getValue(Class<T> type, GetLevel getLevel) {
        Duration cacheThreshold;
        boolean hasExternalGetter;
        this.checkValid();
        if (this.getResourceType() == ResourceType.ACTION) {
            return this.promiseFactory.failed((Throwable)new IllegalArgumentException("This is an action resource"));
        }
        if (this.resource instanceof ResourceAttribute) {
            ResourceAttribute rc = (ResourceAttribute)this.resource;
            hasExternalGetter = rc.isExternalGet();
            cacheThreshold = Duration.of(rc.getExternalGetCacheMs(), ChronoUnit.MILLIS);
        } else {
            hasExternalGetter = false;
            cacheThreshold = null;
        }
        TimedValue<T> cachedValue = this.getValueFromTwin(type);
        if (!hasExternalGetter || getLevel == GetLevel.WEAK) {
            return this.promiseFactory.resolved(cachedValue);
        }
        if (getLevel == GetLevel.STRONG || cachedValue.getTimestamp() == null || cacheThreshold == null || Instant.now().minus(cacheThreshold).isAfter(cachedValue.getTimestamp())) {
            return this.modelNexus.pullValue(this.provider, this.serviceName, this.resource, type, cachedValue);
        }
        return this.promiseFactory.resolved(cachedValue);
    }

    public SensinactService getService() {
        this.checkValid();
        return this.svc;
    }

    public Promise<Void> setMetadataValue(String name, Object value, Instant timestamp) {
        this.checkValid();
        try {
            this.modelNexus.setResourceMetadata(this.provider, this.serviceName, this.resource, name, value, timestamp);
            return this.promiseFactory.resolved(null);
        }
        catch (Throwable t) {
            return this.promiseFactory.failed(t);
        }
    }

    public Promise<TimedValue<Object>> getMetadataValue(String name) {
        this.checkValid();
        TimedValue<Object> resourceMetadata = this.modelNexus.getResourceMetadataValue(this.provider, this.serviceName, this.resource, name);
        if (resourceMetadata == null) {
            return this.promiseFactory.failed((Throwable)new IllegalArgumentException("Resource metadata not found"));
        }
        return this.promiseFactory.resolved(resourceMetadata);
    }

    public Promise<Map<String, Object>> getMetadataValues() {
        this.checkValid();
        Map<String, Object> resourceMetadata = this.modelNexus.getResourceMetadata(this.provider, this.serviceName, this.resource);
        if (resourceMetadata == null) {
            return this.promiseFactory.failed((Throwable)new IllegalArgumentException("Resource not found"));
        }
        return this.promiseFactory.resolved(resourceMetadata);
    }

    public Promise<Object> act(Map<String, Object> parameters) {
        this.checkValid();
        if (this.getResourceType() != ResourceType.ACTION) {
            throw new UnsupportedOperationException("Resource " + String.format("%s/%s/%s", this.provider.getId(), this.svc.getName(), this.getName()) + " is not an ACTION. Only ACTION resources can use the ACT operation");
        }
        return this.modelNexus.act(this.provider, this.serviceName, this.resource, parameters);
    }
}

