/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.Optional;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.rest.ExpansionSettings;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.SnapshotFilter;

public abstract class AbstractAccess {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Providers providers;
    @Context
    protected Application application;
    @Context
    protected ContainerRequestContext requestContext;

    protected SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    protected ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    protected ExpansionSettings getExpansions() {
        ExpansionSettings es = (ExpansionSettings)this.requestContext.getProperty("sensinact.sensorthings.expand");
        return es == null ? ExpansionSettings.EMPTY : es;
    }

    private Optional<ProviderSnapshot> getProviderSnapshot(String id) {
        return this.getSession().filteredSnapshot((ICriterion)new SnapshotFilter(id)).stream().findFirst();
    }

    protected ProviderSnapshot validateAndGetProvider(String id) {
        DtoMapper.validatedProviderId(id);
        Optional<ProviderSnapshot> providerSnapshot = this.getProviderSnapshot(id);
        if (providerSnapshot.isEmpty()) {
            throw new NotFoundException("Unknown provider");
        }
        return providerSnapshot.get();
    }

    protected ResourceSnapshot validateAndGetResourceSnapshot(String id) {
        String resource;
        String service;
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        ResourceSnapshot resourceSnapshot = providerSnapshot.getResource(service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1)), resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2)));
        if (resourceSnapshot == null) {
            throw new NotFoundException();
        }
        return resourceSnapshot;
    }
}

