/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriInfo;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.rest.ExpansionSettings;
import org.eclipse.sensinact.sensorthings.sensing.rest.FeaturesOfInterestAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;

public class FeaturesOfInterestAccessImpl
extends AbstractAccess
implements FeaturesOfInterestAccess {
    public FeatureOfInterest getFeatureOfInterest(String id) {
        FeatureOfInterest foi;
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        try {
            foi = DtoMapper.toFeatureOfInterest(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No feature of interest with id");
        }
        if (!foi.id.equals(id)) {
            throw new NotFoundException();
        }
        return foi;
    }

    public ResultList<Observation> getFeatureOfInterestObservations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return FeaturesOfInterestAccessImpl.getLiveObservations(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
    }

    static ResultList<Observation> getLiveObservations(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ProviderSnapshot provider) {
        ResultList list = new ResultList();
        list.value = provider.getServices().stream().flatMap(s -> s.getResources().stream()).filter(ResourceSnapshot::isSet).map(r -> DtoMapper.toObservation(userSession, application, mapper, uriInfo, expansions, r)).collect(Collectors.toList());
        return list;
    }

    public Observation getFeatureOfInterestObservation(String id, String id2) {
        Observation o;
        String provider2;
        String provider = DtoMapper.extractFirstIdSegment(id);
        if (!provider.equals(provider2 = DtoMapper.extractFirstIdSegment(id2))) {
            throw new BadRequestException("The ids for the FeatureOfInterest and the Observation are inconsistent");
        }
        ResourceSnapshot resourceSnapshot = this.validateAndGetResourceSnapshot(id2);
        try {
            o = DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot);
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
        if (!id2.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Datastream getFeatureOfInterestObservationDatastream(String id, String id2) {
        Datastream d;
        String provider2;
        String provider = DtoMapper.extractFirstIdSegment(id);
        if (!provider.equals(provider2 = DtoMapper.extractFirstIdSegment(id2))) {
            throw new BadRequestException("The ids for the FeatureOfInterest and the Observation are inconsistent");
        }
        ResourceSnapshot resourceSnapshot = this.validateAndGetResourceSnapshot(id2);
        try {
            d = DtoMapper.toDatastream(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot);
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
        if (!id2.startsWith(String.valueOf(d.id))) {
            throw new NotFoundException();
        }
        return d;
    }
}

