/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Geometry;
import org.eclipse.sensinact.gateway.geojson.GeometryCollection;
import org.eclipse.sensinact.gateway.geojson.LineString;
import org.eclipse.sensinact.gateway.geojson.MultiLineString;
import org.eclipse.sensinact.gateway.geojson.MultiPoint;
import org.eclipse.sensinact.gateway.geojson.MultiPolygon;
import org.eclipse.sensinact.gateway.geojson.Polygon;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterBaseVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ParsingException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;

public class GeoGeographyVisitor
extends ODataFilterBaseVisitor<GeoJsonObject> {
    private final SpatialContext spatialContext = SpatialContext.GEO;
    private final ShapeReader shapeReader = this.spatialContext.getFormats().getWktReader();

    private Shape parseShape(ParserRuleContext ctx) {
        try {
            return this.shapeReader.read((Object)ctx.getText());
        }
        catch (IOException | ParseException | InvalidShapeException e) {
            throw new ParsingException("Error parsing geographic point: " + ctx.getText(), e);
        }
    }

    private Coordinates makeCoordinates(Point shpPoint) {
        return this.makeCoordinates(shpPoint.getLon(), shpPoint.getLat());
    }

    private Coordinates makeCoordinates(double lon, double lat) {
        Coordinates coordinates = new Coordinates();
        coordinates.longitude = lon;
        coordinates.latitude = lat;
        return coordinates;
    }

    private List<Double> makeBbox(Shape shape) {
        Rectangle boundingBox = shape.getBoundingBox();
        return List.of(Double.valueOf(boundingBox.getMinX()), Double.valueOf(boundingBox.getMinY()), Double.valueOf(boundingBox.getMaxX()), Double.valueOf(boundingBox.getMaxY()));
    }

    @Override
    public org.eclipse.sensinact.gateway.geojson.Point visitGeographypoint(ODataFilterParser.GeographypointContext ctx) {
        Point parsedPoint = (Point)this.parseShape(ctx.fullpointliteral());
        org.eclipse.sensinact.gateway.geojson.Point point = new org.eclipse.sensinact.gateway.geojson.Point();
        point.coordinates = this.makeCoordinates(parsedPoint);
        point.foreignMembers = Map.of();
        return point;
    }

    @Override
    public LineString visitGeographylinestring(ODataFilterParser.GeographylinestringContext ctx) {
        BufferedLineString parsedLine = (BufferedLineString)this.parseShape(ctx.fulllinestringliteral());
        LineString line = new LineString();
        line.bbox = this.makeBbox((Shape)parsedLine);
        line.coordinates = parsedLine.getPoints().stream().map(this::makeCoordinates).collect(Collectors.toList());
        line.foreignMembers = Map.of();
        return line;
    }

    private boolean checkAllShapes(ShapeCollection<? extends Shape> shapes, Class<? extends Shape> classToTest) {
        return shapes.getShapes().stream().allMatch(s -> classToTest.isAssignableFrom(s.getClass()));
    }

    private Geometry makeGeometry(Shape shape) {
        if (shape instanceof Point) {
            org.eclipse.sensinact.gateway.geojson.Point point = new org.eclipse.sensinact.gateway.geojson.Point();
            point.coordinates = this.makeCoordinates((Point)shape);
            point.foreignMembers = Map.of();
            return point;
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString parsedLine = (BufferedLineString)shape;
            LineString line = new LineString();
            line.bbox = this.makeBbox((Shape)parsedLine);
            line.coordinates = parsedLine.getPoints().stream().map(this::makeCoordinates).collect(Collectors.toList());
            line.foreignMembers = Map.of();
            return line;
        }
        if (shape instanceof Rectangle) {
            return this.makePolygon((Shape)((Rectangle)shape));
        }
        if (shape instanceof ShapeCollection) {
            ShapeCollection shapes = (ShapeCollection)shape;
            Shape firstShape = (Shape)shapes.getShapes().get(0);
            if (firstShape instanceof Point && this.checkAllShapes((ShapeCollection<? extends Shape>)shapes, Point.class)) {
                return this.makeMultiPoint((ShapeCollection<Point>)shapes);
            }
            if (firstShape instanceof BufferedLineString && this.checkAllShapes((ShapeCollection<? extends Shape>)shapes, BufferedLineString.class)) {
                return this.makeMultiLineString((ShapeCollection<BufferedLineString>)shapes);
            }
            if (firstShape instanceof Rectangle && this.checkAllShapes((ShapeCollection<? extends Shape>)shapes, Rectangle.class)) {
                return this.makeMultiPolygon((ShapeCollection<? extends Shape>)shapes);
            }
            GeometryCollection collection = new GeometryCollection();
            collection.bbox = this.makeBbox((Shape)shapes.getBoundingBox());
            collection.foreignMembers = Map.of();
            collection.geometries = shapes.getShapes().stream().map(this::makeGeometry).collect(Collectors.toList());
            return collection;
        }
        throw new ParsingException("Unsupported shape: " + shape);
    }

    private Feature makeFeature(Shape shape) {
        Feature feature = new Feature();
        feature.bbox = this.makeBbox((Shape)shape.getBoundingBox());
        feature.foreignMembers = Map.of();
        feature.properties = Map.of();
        feature.geometry = this.makeGeometry(shape);
        return feature;
    }

    @Override
    public FeatureCollection visitGeographycollection(ODataFilterParser.GeographycollectionContext ctx) {
        ShapeCollection shpCollection = (ShapeCollection)this.parseShape(ctx.fullcollectionliteral());
        FeatureCollection collection = new FeatureCollection();
        collection.foreignMembers = Map.of();
        collection.bbox = this.makeBbox((Shape)shpCollection);
        collection.features = shpCollection.getShapes().stream().map(this::makeFeature).collect(Collectors.toList());
        return collection;
    }

    private MultiLineString makeMultiLineString(ShapeCollection<BufferedLineString> shpCollection) {
        MultiLineString lineStrings = new MultiLineString();
        lineStrings.foreignMembers = Map.of();
        lineStrings.bbox = this.makeBbox((Shape)shpCollection.getBoundingBox());
        lineStrings.coordinates = shpCollection.getShapes().stream().map(lineString -> lineString.getPoints().stream().map(this::makeCoordinates).collect(Collectors.toList())).collect(Collectors.toList());
        return lineStrings;
    }

    @Override
    public MultiLineString visitGeographymultilinestring(ODataFilterParser.GeographymultilinestringContext ctx) {
        ShapeCollection shpCollection = (ShapeCollection)this.parseShape(ctx.fullmultilinestringliteral());
        return this.makeMultiLineString((ShapeCollection<BufferedLineString>)shpCollection);
    }

    private MultiPoint makeMultiPoint(ShapeCollection<Point> shpCollection) {
        MultiPoint points = new MultiPoint();
        points.foreignMembers = Map.of();
        points.bbox = this.makeBbox((Shape)shpCollection);
        points.coordinates = shpCollection.getShapes().stream().map(this::makeCoordinates).collect(Collectors.toList());
        return points;
    }

    @Override
    public MultiPoint visitGeographymultipoint(ODataFilterParser.GeographymultipointContext ctx) {
        ShapeCollection shpCollection = (ShapeCollection)this.parseShape(ctx.fullmultipointliteral());
        return this.makeMultiPoint((ShapeCollection<Point>)shpCollection);
    }

    private Polygon makePolygon(Shape shape) {
        Polygon polygon = new Polygon();
        polygon.foreignMembers = Map.of();
        polygon.bbox = this.makeBbox(shape);
        if (!(shape instanceof Rectangle)) {
            throw new UnsupportedRuleException("Polygons are not supported");
        }
        Rectangle rect = (Rectangle)shape;
        ArrayList<Coordinates> rectPoints = new ArrayList<Coordinates>();
        rectPoints.add(this.makeCoordinates(rect.getMinX(), rect.getMinY()));
        rectPoints.add(this.makeCoordinates(rect.getMinX(), rect.getMaxY()));
        rectPoints.add(this.makeCoordinates(rect.getMaxX(), rect.getMaxY()));
        rectPoints.add(this.makeCoordinates(rect.getMaxX(), rect.getMinY()));
        rectPoints.add(this.makeCoordinates(rect.getMinX(), rect.getMinY()));
        polygon.coordinates = List.of(rectPoints);
        return polygon;
    }

    private MultiPolygon makeMultiPolygon(ShapeCollection<? extends Shape> shpCollection) {
        MultiPolygon polygons = new MultiPolygon();
        polygons.foreignMembers = Map.of();
        polygons.bbox = this.makeBbox((Shape)shpCollection);
        polygons.coordinates = shpCollection.getShapes().stream().map(this::makePolygon).map(p -> p.coordinates).collect(Collectors.toList());
        return polygons;
    }

    @Override
    public MultiPolygon visitGeographymultipolygon(ODataFilterParser.GeographymultipolygonContext ctx) {
        ShapeCollection shpCollection = (ShapeCollection)this.parseShape(ctx.fullmultipolygonliteral());
        return this.makeMultiPolygon((ShapeCollection<? extends Shape>)shpCollection);
    }

    @Override
    public Polygon visitGeographypolygon(ODataFilterParser.GeographypolygonContext ctx) {
        Shape shape = this.parseShape(ctx.fullpolygonliteral());
        return this.makePolygon(shape);
    }
}

