/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.application;

import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.osgitech.rest.dto.DTOConverter;
import org.eclipse.osgitech.rest.proxy.ExtensionProxyFactory;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationContentProvider;
import org.glassfish.jersey.InjectionManagerProvider;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.jakartars.runtime.dto.BaseExtensionDTO;

public class JerseyExtensionProvider
extends JerseyApplicationContentProvider {
    private static final Logger logger = Logger.getLogger("jersey.extensionProvider");
    private static final List<String> POSSIBLE_INTERFACES = Arrays.asList(ContainerRequestFilter.class.getName(), ContainerResponseFilter.class.getName(), ReaderInterceptor.class.getName(), WriterInterceptor.class.getName(), MessageBodyReader.class.getName(), MessageBodyWriter.class.getName(), ContextResolver.class.getName(), ExceptionMapper.class.getName(), ParamConverterProvider.class.getName(), Feature.class.getName(), DynamicFeature.class.getName());
    private Class<?>[] contracts = null;
    private ClassLoader proxyClassLoader = null;

    public JerseyExtensionProvider(ServiceObjects<Object> serviceObjects, Map<String, Object> properties) {
        super(serviceObjects, properties);
        this.checkExtensionProperty(properties);
        this.extractContracts(properties);
    }

    private void checkExtensionProperty(Map<String, Object> properties) {
        if (!properties.containsKey("osgi.jakartars.extension") || properties.get("osgi.jakartars.extension").equals(false)) {
            this.updateStatus(4);
        }
    }

    private void extractContracts(Map<String, Object> properties) {
        String[] objectClasses = (String[])properties.get("objectClass");
        ArrayList possibleContracts = new ArrayList(objectClasses.length);
        for (String objectClass : objectClasses) {
            if (!POSSIBLE_INTERFACES.contains(objectClass)) continue;
            try {
                possibleContracts.add(Class.forName(objectClass));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (!possibleContracts.isEmpty()) {
            this.contracts = possibleContracts.toArray(new Class[0]);
        } else {
            this.updateStatus(4);
        }
    }

    public BaseExtensionDTO getExtensionDTO() {
        int status = this.getProviderStatus();
        if (status == -1) {
            return DTOConverter.toExtensionDTO(this);
        }
        if (status == -10) {
            return DTOConverter.toFailedExtensionDTO(this, 4);
        }
        return DTOConverter.toFailedExtensionDTO(this, status);
    }

    public Class<?>[] getContracts() {
        return this.contracts;
    }

    @Override
    public JerseyExtensionProvider cleanCopy() {
        return new JerseyExtensionProvider((ServiceObjects<Object>)((ServiceObjects)this.getProviderObject()), this.getProviderProperties());
    }

    @Override
    protected String getJakartarsResourceConstant() {
        return "osgi.jakartars.extension";
    }

    public JerseyExtension getExtension(FeatureContext context) {
        Object service = Optional.ofNullable((ServiceObjects)this.getProviderObject()).map(ServiceObjects::getService).orElse(null);
        if (service == null) {
            logger.severe("Unable to get the service object for service " + this.getId() + " with name " + this.getName() + " and contracts" + Arrays.stream(this.contracts).map(Class::getName).collect(Collectors.joining(", ")));
            return null;
        }
        InjectionManagerProvider.getInjectionManager((FeatureContext)context).inject(service);
        return new JerseyExtension(service);
    }

    public class JerseyExtension {
        private Object delegate;

        public JerseyExtension(Object delegate) {
            this.delegate = delegate;
        }

        public Map<Class<?>, Integer> getContractPriorities() {
            Integer priority = Arrays.stream(this.delegate.getClass().getAnnotations()).filter(a -> a.annotationType().getName().equals("jakarta.annotation.Priority")).findFirst().map(a -> {
                try {
                    return (Integer)a.getClass().getMethod("value", new Class[0]).invoke(a, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).orElse(null);
            if (priority == null) {
                return Collections.emptyMap();
            }
            return Arrays.stream(JerseyExtensionProvider.this.contracts).collect(Collectors.toMap(Function.identity(), c -> priority));
        }

        public Object getExtensionObject() {
            if (JerseyExtensionProvider.this.proxyClassLoader == null) {
                JerseyExtensionProvider.this.proxyClassLoader = new ClassLoader(((BundleWiring)((ServiceObjects)JerseyExtensionProvider.this.getProviderObject()).getServiceReference().getBundle().adapt(BundleWiring.class)).getClassLoader()){

                    @Override
                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        byte[] b = ExtensionProxyFactory.generateClass(name, JerseyExtension.this.getDelegate(), Arrays.asList(JerseyExtensionProvider.this.contracts));
                        return this.defineClass(name, b, 0, b.length, JerseyExtension.this.delegate.getClass().getProtectionDomain());
                    }
                };
            }
            String simpleName = ExtensionProxyFactory.getSimpleName(JerseyExtensionProvider.this.getServiceRank(), JerseyExtensionProvider.this.getServiceId());
            try {
                Class<?> clz = JerseyExtensionProvider.this.proxyClassLoader.loadClass("org.eclipse.osgitech.rest.proxy." + simpleName);
                return clz.getConstructor(Supplier.class).newInstance(this::getDelegate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getDelegate() {
            Object toReturn;
            JerseyExtension jerseyExtension = this;
            synchronized (jerseyExtension) {
                toReturn = this.delegate;
            }
            if (toReturn == null) {
                throw new IllegalStateException("The target extension " + JerseyExtensionProvider.this.getName() + " has been disposed");
            }
            return toReturn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object toRelease;
            JerseyExtension jerseyExtension = this;
            synchronized (jerseyExtension) {
                toRelease = this.delegate;
                this.delegate = null;
            }
            if (toRelease != null) {
                ((ServiceObjects)JerseyExtensionProvider.this.getProviderObject()).ungetService(toRelease);
            }
        }
    }
}

