/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.ThingsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DatastreamsAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class ThingsAccessImpl
extends AbstractAccess
implements ThingsAccess {
    public Thing getThing(String id) {
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(id);
        return DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
    }

    public ResultList<Datastream> getThingDatastreams(String id) {
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(id);
        return DatastreamsAccessImpl.getDataStreams(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
    }

    public Datastream getThingDatastream(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        Datastream d = DtoMapper.toDatastream(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id2));
        if (!id2.equals(d.id)) {
            throw new NotFoundException();
        }
        return d;
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getThingDatastreamObservations(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        return RootResourceAccessImpl.getObservationList(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id2), 0);
    }

    public ObservedProperty getThingDatastreamObservedProperty(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        ObservedProperty o = DtoMapper.toObservedProperty(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id2));
        if (!id2.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Sensor getThingDatastreamSensor(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        Sensor s = DtoMapper.toSensor(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id2));
        if (!id2.equals(s.id)) {
            throw new NotFoundException();
        }
        return s;
    }

    public Thing getThingDatastreamThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        return this.getThing(id);
    }

    public ResultList<HistoricalLocation> getThingHistoricalLocations(String id) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    public HistoricalLocation getThingHistoricalLocation(String id, String id2) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        DtoMapper.getTimestampFromId(id2);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        return hl;
    }

    public Thing getThingHistoricalLocationsThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        return this.getThing(id);
    }

    public ResultList<Location> getThingHistoricalLocationLocations(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        DtoMapper.getTimestampFromId(id2);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider)));
        return list;
    }

    public ResultList<Location> getThingLocations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider)));
        return list;
    }

    public Location getThingLocation(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        DtoMapper.getTimestampFromId(id2);
        Location l = DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
        if (!id2.equals(l.id)) {
            throw new NotFoundException();
        }
        return l;
    }

    public ResultList<Thing> getThingLocationThings(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(this.getThing(id));
        return list;
    }

    public ResultList<HistoricalLocation> getThingLocationHistoricalLocations(String id, String id2) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id2);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }
}

