/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.geojson.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.Geometry;
import org.eclipse.sensinact.gateway.geojson.GeometryCollection;
import org.eclipse.sensinact.gateway.geojson.LineString;
import org.eclipse.sensinact.gateway.geojson.MultiLineString;
import org.eclipse.sensinact.gateway.geojson.MultiPoint;
import org.eclipse.sensinact.gateway.geojson.MultiPolygon;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.geojson.Polygon;

public class GeoJsonUtils {
    public static Coordinates coords(double longitude, double latitude) {
        return GeoJsonUtils.coords(longitude, latitude, Double.NaN);
    }

    public static Coordinates coords(double longitude, double latitude, double elevation) {
        Coordinates coordinates = new Coordinates();
        coordinates.longitude = longitude;
        coordinates.latitude = latitude;
        coordinates.elevation = elevation;
        return coordinates;
    }

    public static Point point(Coordinates coords) {
        Point point = new Point();
        point.coordinates = coords;
        return point;
    }

    public static Point point(double longitude, double latitude) {
        return GeoJsonUtils.point(GeoJsonUtils.coords(longitude, latitude));
    }

    public static Point point(double longitude, double latitude, double elevation) {
        return GeoJsonUtils.point(GeoJsonUtils.coords(longitude, latitude, elevation));
    }

    public static MultiPoint multiPoint(Coordinates ... points) {
        MultiPoint multipoint = new MultiPoint();
        multipoint.coordinates = Arrays.asList(points);
        return multipoint;
    }

    public static MultiPoint multiPoint(Point ... points) {
        MultiPoint multipoint = new MultiPoint();
        multipoint.coordinates = new ArrayList<Coordinates>();
        for (Point point : points) {
            multipoint.coordinates.add(point.coordinates);
        }
        return multipoint;
    }

    public static LineString lineString(Coordinates firstPoint, Coordinates secondPoint, Coordinates ... otherPoints) {
        LineString lineString = new LineString();
        lineString.coordinates = new ArrayList<Coordinates>();
        lineString.coordinates.add(firstPoint);
        lineString.coordinates.add(secondPoint);
        if (otherPoints != null) {
            lineString.coordinates.addAll(Arrays.asList(otherPoints));
        }
        return lineString;
    }

    public static MultiLineString multiLineString(LineString ... lineStrings) {
        MultiLineString multiLineString = new MultiLineString();
        multiLineString.coordinates = new ArrayList<List<Coordinates>>();
        for (LineString lineString : lineStrings) {
            multiLineString.coordinates.add(lineString.coordinates);
        }
        return multiLineString;
    }

    public static Polygon polygon(Coordinates firstPoint, Coordinates secondPoint, Coordinates thirdPoint, Coordinates ... otherPoints) {
        ArrayList<Coordinates> exteriorRing = new ArrayList<Coordinates>();
        exteriorRing.add(firstPoint);
        exteriorRing.add(secondPoint);
        exteriorRing.add(thirdPoint);
        if (otherPoints != null && otherPoints.length > 0) {
            exteriorRing.addAll(Arrays.asList(otherPoints));
            Coordinates lastPoint = otherPoints[otherPoints.length - 1];
            if (!Objects.equals(firstPoint, lastPoint)) {
                exteriorRing.add(firstPoint);
            }
        } else {
            exteriorRing.add(firstPoint);
        }
        Polygon polygon = new Polygon();
        polygon.coordinates = List.of(exteriorRing);
        return polygon;
    }

    public static Polygon polygon(Point firstPoint, Point secondPoint, Point thirdPoint, Point ... otherPoints) {
        return GeoJsonUtils.polygon(firstPoint.coordinates, secondPoint.coordinates, thirdPoint.coordinates, (Coordinates[])Arrays.stream(otherPoints).map(p -> p.coordinates).toArray(Coordinates[]::new));
    }

    public static Polygon polygon(LineString exteriorRing, LineString ... interiorRings) {
        Polygon polygon = new Polygon();
        polygon.coordinates = new ArrayList<List<Coordinates>>();
        polygon.coordinates.addAll(List.of(exteriorRing.coordinates));
        polygon.bbox = exteriorRing.bbox;
        if (interiorRings != null) {
            for (LineString interiorRing : interiorRings) {
                polygon.coordinates.addAll(List.of(interiorRing.coordinates));
            }
        }
        return polygon;
    }

    public static MultiPolygon multiPolygon(Polygon ... polygons) {
        MultiPolygon multiPolygon = new MultiPolygon();
        multiPolygon.coordinates = new ArrayList<List<List<Coordinates>>>();
        for (Polygon polygon : polygons) {
            multiPolygon.coordinates.add(polygon.coordinates);
        }
        return multiPolygon;
    }

    public static GeometryCollection geometryCollection(Geometry ... geometries) {
        GeometryCollection collection = new GeometryCollection();
        collection.geometries = Arrays.asList(geometries);
        return collection;
    }

    public static Feature feature(String id, Geometry geometry) {
        Feature feature = new Feature();
        feature.id = id;
        feature.geometry = geometry;
        return feature;
    }

    public static FeatureCollection featureCollection(Feature ... features) {
        FeatureCollection collection = new FeatureCollection();
        collection.features = Arrays.asList(features);
        return collection;
    }
}

