/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.http.MappingMatch;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.http.base.internal.dispatch.RequestDispatcherImpl;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.registry.ServletResolution;
import org.apache.felix.http.base.internal.util.UriUtils;

public class SharedServletContextImpl
implements ServletContext {
    private final ServletContext context;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final String contextPath;
    private final String name;
    private final PerContextHandlerRegistry registry;
    private final ServletContextAttributeListener attributeListener;
    private final Map<String, String> initParameters = new HashMap<String, String>();

    public SharedServletContextImpl(ServletContext webContext, String name, String path, Map<String, String> initParameters, PerContextHandlerRegistry registry) {
        this.context = webContext;
        this.contextPath = path.equals("/") ? webContext.getContextPath() : webContext.getContextPath() + path;
        this.name = name;
        if (initParameters != null) {
            this.initParameters.putAll(initParameters);
        }
        this.attributeListener = registry.getEventListenerRegistry();
        this.registry = registry;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public URL getResource(String path) {
        return null;
    }

    public String getMimeType(String file) {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> type) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<? extends EventListener> type) {
        throw new UnsupportedOperationException();
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> void addListener(T listener) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> type) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends Filter> T createFilter(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> T createListener(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException();
    }

    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcherImpl dispatcher;
        if (name == null) {
            return null;
        }
        ServletHandler servletHandler = this.registry.resolveServletByName(name);
        if (servletHandler != null) {
            ServletResolution resolution = new ServletResolution();
            resolution.handler = servletHandler;
            resolution.handlerRegistry = this.registry;
            RequestInfo requestInfo = new RequestInfo("", null, null, null, name, "", "", MappingMatch.EXACT, true);
            dispatcher = new RequestDispatcherImpl(resolution, requestInfo);
        } else {
            dispatcher = null;
        }
        return dispatcher;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcherImpl dispatcher;
        String encodedRequestURI;
        String requestURI;
        PathResolution pathResolution;
        if (path == null || !path.startsWith("/") && !"".equals(path)) {
            return null;
        }
        String query = null;
        int q = 0;
        q = path.indexOf(63);
        if (q > 0) {
            query = path.substring(q + 1);
            path = path.substring(0, q);
        }
        if ((pathResolution = this.registry.resolve(requestURI = UriUtils.decodePath(encodedRequestURI = path == null ? "" : UriUtils.removeDotSegments(path)))) != null) {
            pathResolution.handlerRegistry = this.registry;
            RequestInfo requestInfo = new RequestInfo(pathResolution.servletPath, pathResolution.pathInfo, query, UriUtils.concat(this.contextPath, encodedRequestURI), pathResolution.handler.getName(), pathResolution.matchedPattern, pathResolution.matchValue, pathResolution.match, false);
            dispatcher = new RequestDispatcherImpl(pathResolution, requestInfo);
        } else {
            dispatcher = null;
        }
        return dispatcher;
    }

    public InputStream getResourceAsStream(String path) {
        return null;
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.context.getServlet(name);
    }

    public String getServletContextName() {
        return this.name;
    }

    public Enumeration<String> getServletNames() {
        return this.context.getServletNames();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    public Enumeration<Servlet> getServlets() {
        return this.context.getServlets();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    public void log(Exception cause, String message) {
        SystemLogger.LOGGER.error(message, (Throwable)cause);
    }

    public void log(String message) {
        SystemLogger.LOGGER.info(message);
    }

    public void log(String message, Throwable cause) {
        SystemLogger.LOGGER.error(message, cause);
    }

    public void removeAttribute(String name) {
        Object oldValue = this.attributes.remove(name);
        if (oldValue != null) {
            this.attributeListener.attributeRemoved(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else if (name != null) {
            Object oldValue = this.attributes.put(name, value);
            if (oldValue == null) {
                this.attributeListener.attributeAdded(new ServletContextAttributeEvent((ServletContext)this, name, value));
            } else {
                this.attributeListener.attributeReplaced(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
            }
        }
    }

    public boolean setInitParameter(String name, String value) {
        throw new IllegalStateException();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> modes) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException();
    }

    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new IllegalStateException();
    }

    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        throw new IllegalStateException();
    }

    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        throw new IllegalStateException();
    }
}

