/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.AbstractCriterion;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.ILdapCriterion;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.LdapOperator;

public class LdapFilter
extends AbstractCriterion {
    private final List<ILdapCriterion> subCriteria = new ArrayList<ILdapCriterion>();
    private LdapOperator operator;

    public LdapFilter(LdapOperator operator, List<ILdapCriterion> criteria) {
        this.operator = operator;
        this.subCriteria.addAll(criteria);
    }

    @Override
    public void negate() {
        switch (this.operator) {
            case AND: {
                this.operator = LdapOperator.OR;
                this.subCriteria.forEach(ILdapCriterion::negate);
                break;
            }
            case OR: {
                this.operator = LdapOperator.AND;
                this.subCriteria.forEach(ILdapCriterion::negate);
                break;
            }
        }
    }

    public String toString() {
        String op;
        switch (this.operator) {
            case AND: {
                op = "&";
                break;
            }
            case OR: {
                op = "|";
                break;
            }
            default: {
                op = "?";
            }
        }
        return String.format("(%s%s)", op, this.subCriteria.stream().map(Objects::toString).reduce("", (a, b) -> a + b));
    }

    private Predicate<ProviderSnapshot> makeProviderFilter(List<Predicate<ProviderSnapshot>> criteria) {
        if (criteria.isEmpty()) {
            return null;
        }
        switch (this.operator) {
            case AND: {
                return p -> criteria.stream().allMatch(c -> c.test(p));
            }
            case OR: {
                return p -> criteria.stream().anyMatch(c -> c.test(p));
            }
        }
        return null;
    }

    @Override
    public Predicate<ProviderSnapshot> getProviderFilter() {
        List allCriteria = this.subCriteria.stream().map(ICriterion::getProviderFilter).collect(Collectors.toList());
        List<Predicate<ProviderSnapshot>> filteredCriteria = allCriteria.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (filteredCriteria.isEmpty() || filteredCriteria.size() != allCriteria.size()) {
            return null;
        }
        return this.makeProviderFilter(filteredCriteria);
    }

    @Override
    public ResourceValueFilter getResourceValueFilter() {
        List allCriteria = this.subCriteria.stream().map(ICriterion::getResourceValueFilter).filter(Objects::nonNull).collect(Collectors.toList());
        if (allCriteria.isEmpty()) {
            return (p, rs) -> true;
        }
        Predicate<ProviderSnapshot> pFilter = this.makeProviderFilter(this.subCriteria.stream().map(ICriterion::getProviderFilter).filter(Objects::nonNull).collect(Collectors.toList()));
        switch (this.operator) {
            case AND: {
                return (p, rs) -> !rs.isEmpty() && (pFilter == null || pFilter.test(p)) && allCriteria.stream().allMatch(c -> c.test(p, rs));
            }
            case OR: {
                return (p, rs) -> !rs.isEmpty() && (pFilter != null && pFilter.test(p) || allCriteria.stream().anyMatch(c -> c.test(p, rs)));
            }
        }
        return null;
    }
}

