/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.ResourceBuilder;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.model.impl.NestableBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ResourceImpl;
import org.eclipse.sensinact.core.model.impl.ServiceImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;

public class ResourceBuilderImpl<R, T>
extends NestableBuilderImpl<R, ServiceImpl, Resource>
implements ResourceBuilder<R, T> {
    private final String name;
    private final ModelNexus nexusImpl;
    private Class<?> type;
    private Object initialValue;
    private Instant timestamp;
    private Map<String, Object> defaultMetadata;
    private ResourceType resourceType = null;
    private List<Map.Entry<String, Class<?>>> namedParameterTypes;
    private boolean hasGetter;
    private long getterCacheMs;
    private boolean hasSetter;

    public ResourceBuilderImpl(AtomicBoolean active, R parent, ServiceImpl builtParent, String name, ModelNexus nexusImpl) {
        super(active, parent, builtParent);
        this.name = name;
        this.nexusImpl = nexusImpl;
    }

    public ResourceBuilder<R, T> exclusivelyOwned(boolean exclusive) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public ResourceBuilder<R, T> withAutoDeletion(boolean autoDelete) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public <U extends T> ResourceBuilder<R, U> withType(Class<U> type) {
        this.checkValid();
        this.type = type;
        return this;
    }

    public <U extends T> ResourceBuilder<R, U> withInitialValue(U initialValue) {
        this.checkValid();
        this.initialValue = initialValue;
        return this;
    }

    public <U extends T> ResourceBuilder<R, U> withInitialValue(U initialValue, Instant timestamp) {
        this.checkValid();
        this.initialValue = initialValue;
        this.timestamp = timestamp;
        return this;
    }

    public ResourceBuilder<R, T> withDefaultMetadata(Map<String, Object> defaultMetadata) {
        this.checkValid();
        this.defaultMetadata = Map.copyOf(defaultMetadata);
        return this;
    }

    public ResourceBuilder<R, T> withValueType(ValueType valueType) {
        this.checkValid();
        return this;
    }

    public ResourceBuilder<R, T> withResourceType(ResourceType resourceType) {
        this.checkValid();
        this.resourceType = resourceType;
        return this;
    }

    public ResourceBuilder<R, T> withAction(List<Map.Entry<String, Class<?>>> namedParameterTypes) {
        this.checkValid();
        this.resourceType = ResourceType.ACTION;
        this.namedParameterTypes = namedParameterTypes;
        return this;
    }

    public ResourceBuilder<R, T> withGetter(boolean hasGet) {
        this.checkValid();
        this.hasGetter = hasGet;
        return this;
    }

    public ResourceBuilder<R, T> withGetterCache(Duration cacheDuration) {
        this.checkValid();
        this.getterCacheMs = cacheDuration == null || cacheDuration.isNegative() ? 0L : cacheDuration.toMillis();
        return this;
    }

    public ResourceBuilder<R, T> withSetter(boolean hasSet) {
        this.checkValid();
        this.hasSetter = hasSet;
        return this;
    }

    @Override
    protected void doValidate() {
        super.doValidate();
        if (this.resourceType == null) {
            this.resourceType = ResourceType.SENSOR;
        }
        if (this.resourceType == ResourceType.SENSOR) {
            if (this.namedParameterTypes != null) {
                throw new IllegalArgumentException("Action details cannot be set for a SENSOR resource");
            }
            if (this.type == null && this.initialValue == null) {
                throw new IllegalArgumentException("The resource " + this.name + " must define a type or a value");
            }
            if (this.type == null) {
                this.type = this.initialValue.getClass();
            } else if (this.initialValue != null && !this.type.isInstance(this.initialValue)) {
                throw new IllegalArgumentException("The initial value " + this.initialValue + " for resource " + this.name + " is not compatible with the type " + this.type.getName());
            }
        } else if (this.resourceType == ResourceType.ACTION) {
            if (this.type == null) {
                throw new IllegalArgumentException("The action resource " + this.name + " must define a type");
            }
            if (this.namedParameterTypes == null) {
                throw new IllegalArgumentException("The action resource " + this.name + " must define parameters");
            }
            if (this.hasGetter || this.hasSetter) {
                throw new IllegalArgumentException("Can't define an external get or set on an ACTION resource");
            }
        } else {
            throw new RuntimeException("No implemented support for type " + this.resourceType);
        }
    }

    @Override
    protected Resource doBuild(ServiceImpl builtParent) {
        EOperation createResource;
        switch (this.resourceType) {
            case ACTION: {
                createResource = this.nexusImpl.createActionResource(builtParent.getServiceEClass(), this.name, this.type, this.namedParameterTypes, this.defaultMetadata);
                break;
            }
            case SENSOR: {
                createResource = this.nexusImpl.createResource(builtParent.getServiceEClass(), this.name, this.type, this.timestamp, this.initialValue, this.defaultMetadata, this.hasGetter, this.getterCacheMs, this.hasSetter);
                break;
            }
            default: {
                throw new RuntimeException("Should be unreachable");
            }
        }
        return new ResourceImpl(this.active, (Service)builtParent, (ETypedElement)createResource);
    }
}

