/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.DatastreamsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.ExpansionSettings;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class DatastreamsAccessImpl
extends AbstractAccess
implements DatastreamsAccess {
    public Datastream getDatastream(String id) {
        return DtoMapper.toDatastream(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id));
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getDatastreamObservations(String id) {
        return RootResourceAccessImpl.getObservationList(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id), 0);
    }

    public Observation getDatastreamObservation(String id, String id2) {
        Observation o = DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id));
        if (!id2.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Datastream getDatastreamObservationDatastream(String id, String id2) {
        return this.getDatastream(id);
    }

    public FeatureOfInterest getDatastreamObservationFeatureOfInterest(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toFeatureOfInterest(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
    }

    public ObservedProperty getDatastreamObservedProperty(String id) {
        ObservedProperty o = DtoMapper.toObservedProperty(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id));
        if (!id.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public ResultList<Datastream> getDatastreamObservedPropertyDatastreams(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getDatastream(id));
        return list;
    }

    public Sensor getDatastreamSensor(String id) {
        Sensor s = DtoMapper.toSensor(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id));
        if (!id.equals(s.id)) {
            throw new NotFoundException();
        }
        return s;
    }

    public ResultList<Datastream> getDatastreamSensorDatastreams(String id) {
        return this.getDatastreamObservedPropertyDatastreams(id);
    }

    public Thing getDatastreamThing(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
    }

    public ResultList<Datastream> getDatastreamThingDatastreams(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DatastreamsAccessImpl.getDataStreams(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
    }

    public ResultList<HistoricalLocation> getDatastreamThingHistoricalLocations(String id) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    public ResultList<Location> getDatastreamThingLocations(String id) {
        Location hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    static ResultList<Datastream> getDataStreams(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ProviderSnapshot providerSnapshot) {
        ResultList list = new ResultList();
        list.value = providerSnapshot.getServices().stream().flatMap(s -> s.getResources().stream()).filter(r -> !r.getMetadata().containsKey("sensorthings.observedArea")).map(r -> DtoMapper.toDatastream(userSession, application, mapper, uriInfo, expansions, r)).collect(Collectors.toList());
        return list;
    }
}

