/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.filters.sensorthings.EFilterContext;

public class ResourceValueFilterInputHolder {
    private final EFilterContext context;
    private final ProviderSnapshot provider;
    private final List<ResourceSnapshot> resources;
    private final ResourceSnapshot resource;

    public ResourceValueFilterInputHolder(EFilterContext context, ProviderSnapshot provider, List<ResourceSnapshot> resources) {
        this.context = context;
        this.provider = provider;
        this.resources = resources;
        this.resource = null;
    }

    public ResourceValueFilterInputHolder(EFilterContext context, ProviderSnapshot provider, ResourceSnapshot resource) {
        this.context = context;
        this.provider = provider;
        this.resources = List.of(resource);
        this.resource = resource;
    }

    public ResourceValueFilterInputHolder(EFilterContext context, ResourceSnapshot resource) {
        this(context, resource.getService().getProvider(), resource);
    }

    public String toString() {
        return String.format("Holder(%s -> %s)", this.provider.getName(), this.resources.stream().map(r -> String.format("%s/%s/%s=%s", r.getService().getProvider().getName(), r.getService().getName(), r.getName(), r.getValue())).collect(Collectors.toList()));
    }

    public EFilterContext getContext() {
        return this.context;
    }

    public ProviderSnapshot getProvider() {
        return this.provider;
    }

    public List<ResourceSnapshot> getResources() {
        return this.resources;
    }

    public ResourceSnapshot getResource() {
        return this.resource;
    }
}

