/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl.snapshot;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.sensinact.core.impl.snapshot.AbstractSnapshot;
import org.eclipse.sensinact.core.impl.snapshot.ProviderSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ServiceSnapshotImpl;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.model.impl.ResourceImpl;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.model.core.metadata.MetadataFactory;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Service;

public class ResourceSnapshotImpl
extends AbstractSnapshot
implements ResourceSnapshot {
    private TimedValue<?> rcValue;
    private final ServiceSnapshotImpl service;
    private final ETypedElement rcFeature;
    private final Map<String, Object> metadata;
    private final Class<?> type;
    private final ResourceType resourceType;
    private final ValueType valueType;

    public ResourceSnapshotImpl(ServiceSnapshotImpl parent, ETypedElement rcFeature, Instant snapshotInstant) {
        super(rcFeature.getName(), snapshotInstant);
        Metadata rcMetadata;
        this.service = parent;
        this.rcFeature = rcFeature;
        this.type = rcFeature.getEType().getInstanceClass();
        this.resourceType = ResourceImpl.findResourceType(rcFeature);
        this.valueType = ValueType.UPDATABLE;
        Service modelService = parent.getModelService();
        Metadata metadata = rcMetadata = modelService == null ? null : (Metadata)modelService.getMetadata().get((Object)rcFeature);
        if (rcMetadata == null) {
            rcMetadata = MetadataFactory.eINSTANCE.createResourceMetadata();
            if (rcFeature instanceof Metadata) {
                rcMetadata.getExtra().addAll((Collection)((Metadata)rcFeature).getExtra());
            }
        }
        HashMap<String, Object> rcMeta = new HashMap<String, Object>();
        rcMeta.putAll(EMFUtil.toMetadataAttributesToMap(rcMetadata, rcFeature));
        this.metadata = rcMeta;
    }

    public String toString() {
        ProviderSnapshotImpl provider = this.service.getProvider();
        return String.format("ResourceSnapshot(%s/%s/%s/%s, %s)", provider.getModelName(), provider.getName(), this.service.getName(), this.getName(), this.getSnapshotTime());
    }

    public ServiceSnapshotImpl getService() {
        return this.service;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public TimedValue<?> getValue() {
        return this.rcValue;
    }

    public void setValue(TimedValue<?> value) {
        this.rcValue = value;
    }

    public boolean isSet() {
        return this.getValue() != null && this.getValue().getTimestamp() != null;
    }

    public Class<?> getType() {
        return this.type;
    }

    public ETypedElement getFeature() {
        return this.rcFeature;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }
}

