/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import org.eclipse.sensinact.gateway.geojson.internal.CoordinatesDeserializer;
import org.eclipse.sensinact.gateway.geojson.internal.CoordinatesSerializer;

@JsonDeserialize(using=CoordinatesDeserializer.class)
@JsonSerialize(using=CoordinatesSerializer.class)
public class Coordinates {
    public double longitude;
    public double latitude;
    public double elevation = Double.NaN;

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude, this.elevation);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == Coordinates.class) {
            double epsilon = 1.0E-7;
            Coordinates other = (Coordinates)obj;
            if (Math.abs(other.longitude - this.longitude) >= 1.0E-7) {
                return false;
            }
            if (Math.abs(other.latitude - this.latitude) >= 1.0E-7) {
                return false;
            }
            if (Double.isFinite(other.elevation) && Double.isFinite(this.elevation)) {
                return Math.abs(other.latitude - this.latitude) < 1.0E-7;
            }
            return !Double.isFinite(other.elevation) && !Double.isFinite(this.elevation);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(lon=").append(this.longitude).append(",lat=").append(this.latitude);
        if (Double.isFinite(this.elevation)) {
            builder.append(",alt=").append(this.elevation);
        }
        return builder.append(")").toString();
    }
}

