/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.geojson;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.GeoJsonType;
import org.eclipse.sensinact.gateway.geojson.GeometryCollection;
import org.eclipse.sensinact.gateway.geojson.LineString;
import org.eclipse.sensinact.gateway.geojson.MultiLineString;
import org.eclipse.sensinact.gateway.geojson.MultiPoint;
import org.eclipse.sensinact.gateway.geojson.MultiPolygon;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.geojson.Polygon;

@JsonSubTypes(value={@JsonSubTypes.Type(value=Feature.class, name="Feature"), @JsonSubTypes.Type(value=FeatureCollection.class, name="FeatureCollection"), @JsonSubTypes.Type(value=Point.class, name="Point"), @JsonSubTypes.Type(value=MultiPoint.class, name="MultiPoint"), @JsonSubTypes.Type(value=LineString.class, name="LineString"), @JsonSubTypes.Type(value=MultiLineString.class, name="MultiLineString"), @JsonSubTypes.Type(value=Polygon.class, name="Polygon"), @JsonSubTypes.Type(value=MultiPolygon.class, name="MultiPolygon"), @JsonSubTypes.Type(value=GeometryCollection.class, name="GeometryCollection")})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class GeoJsonObject {
    @JsonIgnoreProperties(allowGetters=true)
    public final GeoJsonType type;
    @JsonAnySetter
    public Map<String, Object> foreignMembers = new HashMap<String, Object>();
    public List<Double> bbox;

    protected GeoJsonObject(GeoJsonType type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.bbox});
    }

    protected boolean checkParentEquals(Object obj) {
        if (obj instanceof GeoJsonObject) {
            GeoJsonObject other = (GeoJsonObject)obj;
            return this.type == other.type && Objects.equals(this.bbox, other.bbox) && Objects.equals(this.foreignMembers, other.foreignMembers);
        }
        return false;
    }

    protected abstract boolean getObjectDescription(StringBuilder var1);

    public String toString() {
        boolean first;
        StringBuilder builder = new StringBuilder(this.type.toString()).append("(");
        boolean bl = first = !this.getObjectDescription(builder);
        if (this.bbox != null && !this.bbox.isEmpty()) {
            if (first) {
                builder.append(", ");
                first = false;
            }
            builder.append("bbox=[").append(this.bbox).append("]");
        }
        if (this.foreignMembers != null && !this.foreignMembers.isEmpty()) {
            if (first) {
                builder.append(", ");
                first = false;
            }
            builder.append("hasForeignMembers=true");
        }
        return builder.append(")").toString();
    }
}

