/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.northbound.filters.api.FilterException;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class FilterCommandHelper {
    public static Collection<ProviderSnapshot> executeFilter(GatewayThread thread, final ICriterion criterion) throws FilterException {
        Collection providers;
        try {
            providers = (Collection)thread.execute((AbstractSensinactCommand)new AbstractTwinCommand<Collection<ProviderSnapshot>>(){

                protected Promise<Collection<ProviderSnapshot>> call(SensinactDigitalTwin model, PromiseFactory pf) {
                    return pf.resolved((Object)model.filteredSnapshot(criterion.getLocationFilter(), criterion.getProviderFilter(), criterion.getServiceFilter(), criterion.getResourceFilter()));
                }
            }).getValue();
        }
        catch (InterruptedException e) {
            throw new FilterException("Interrupted creating snapshot", e);
        }
        catch (InvocationTargetException e) {
            throw new FilterException("Error creating snapshot", e.getCause());
        }
        if (criterion.getResourceValueFilter() != null) {
            ResourceValueFilter rcFilter = criterion.getResourceValueFilter();
            return providers.stream().filter(p -> rcFilter.test(p, p.getServices().stream().flatMap(s -> s.getResources().stream()).collect(Collectors.toList()))).collect(Collectors.toList());
        }
        return List.copyOf(providers);
    }
}

