/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.binder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

class PromiseResourceMethodInvocationHandlerProvider
implements ResourceMethodInvocationHandlerProvider {
    private final Map<Class<?>, InvocationHandler> cachedHandlers = new ConcurrentHashMap();

    PromiseResourceMethodInvocationHandlerProvider() {
    }

    public InvocationHandler create(Invocable method) {
        Class rawResponseType = method.getRawResponseType();
        if ("org.osgi.util.promise.Promise".equals(rawResponseType.getName())) {
            return this.cachedHandlers.computeIfAbsent(rawResponseType, PromiseResourceMethodInvocationHandler::new);
        }
        return null;
    }

    static class PromiseResourceMethodInvocationHandler
    implements InvocationHandler {
        private final Class<?> promiseClass;
        private final Method register;
        private final Method getFailure;
        private final Method getValue;
        private final Method isDone;

        public PromiseResourceMethodInvocationHandler(Class<?> promiseClass) {
            this.promiseClass = promiseClass;
            try {
                this.register = promiseClass.getMethod("onResolve", Runnable.class);
                this.getFailure = promiseClass.getMethod("getFailure", new Class[0]);
                this.getValue = promiseClass.getMethod("getValue", new Class[0]);
                this.isDone = promiseClass.getMethod("isDone", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set up InvocationHandler for Class " + promiseClass, e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            CompletableFuture<Object> result = method.invoke(proxy, args);
            if (result != null && this.promiseClass.isInstance(result)) {
                if (((Boolean)this.isDone.invoke((Object)result, new Object[0])).booleanValue()) {
                    Throwable t = (Throwable)this.getFailure.invoke(result, new Object[0]);
                    if (t != null) {
                        throw t;
                    }
                    result = this.getValue.invoke((Object)t, new Object[0]);
                } else {
                    result = this.handleAsync(result);
                }
            }
            return result;
        }

        private CompletableFuture<Object> handleAsync(Object promise) throws IllegalAccessException, InvocationTargetException {
            CompletableFuture<Object> resultAsFuture = new CompletableFuture<Object>();
            this.register.invoke(promise, () -> {
                try {
                    Throwable t = (Throwable)this.getFailure.invoke(promise, new Object[0]);
                    if (t != null) {
                        resultAsFuture.completeExceptionally(t);
                    } else {
                        resultAsFuture.complete(this.getValue.invoke(promise, new Object[0]));
                    }
                }
                catch (Exception e) {
                    resultAsFuture.completeExceptionally(e);
                }
            });
            return resultAsFuture;
        }
    }
}

