/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.helper;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;

public class JakartarsHelper {
    public static String getFullApplicationPath(Application application, String applicationBase) {
        ApplicationPath applicationPathAnnotation;
        String strippedBase = JakartarsHelper.stripApplicationPath(applicationBase);
        if (application != null && (applicationPathAnnotation = application.getClass().getAnnotation(ApplicationPath.class)) != null) {
            return strippedBase + JakartarsHelper.stripApplicationPath(applicationPathAnnotation.value());
        }
        return strippedBase;
    }

    public static String getServletPath(Application application, String applicationBase) {
        ApplicationPath applicationPathAnnotation;
        if (application != null && (applicationPathAnnotation = application.getClass().getAnnotation(ApplicationPath.class)) != null) {
            String applicationPath = applicationPathAnnotation.value();
            String stripedApplicationBase = JakartarsHelper.stripApplicationPath(applicationBase);
            return stripedApplicationBase + JakartarsHelper.toServletPath(applicationPath);
        }
        return JakartarsHelper.toServletPath(applicationBase);
    }

    private static String stripApplicationPath(String applicationPath) {
        Object resultPath;
        Object object = resultPath = applicationPath.startsWith("/") ? "" : "/";
        resultPath = applicationPath.endsWith("/*") ? (String)resultPath + applicationPath.substring(0, applicationPath.length() - 2) : (applicationPath.endsWith("/") ? (String)resultPath + applicationPath.substring(0, applicationPath.length() - 1) : (String)resultPath + applicationPath);
        return resultPath;
    }

    public static String toServletPath(String path) {
        return "/" + JakartarsHelper.toApplicationPath(path);
    }

    public static String toApplicationPath(String path) {
        Object applicationPath = "*";
        if (path == null || path.isEmpty() || path.equals("/")) {
            return applicationPath;
        }
        applicationPath = path;
        if (applicationPath != null && !((String)applicationPath).isEmpty()) {
            if (((String)applicationPath).startsWith("/")) {
                applicationPath = ((String)applicationPath).substring(1, ((String)applicationPath).length());
            }
            if (!((String)applicationPath).endsWith("/") && !((String)applicationPath).endsWith("/*")) {
                applicationPath = (String)applicationPath + "/*";
            }
            if (((String)applicationPath).endsWith("/")) {
                applicationPath = (String)applicationPath + "*";
            }
        }
        return applicationPath;
    }
}

