/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.extract.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.FailedMappingDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.core.push.dto.GenericDto;

public class GenericDtoDataExtractor
implements DataExtractor {
    @Override
    public List<? extends AbstractUpdateDto> getUpdates(Object update) {
        AbstractUpdateDto dud;
        Instant instant;
        GenericDto dto;
        try {
            dto = (GenericDto)GenericDto.class.cast(update);
        }
        catch (ClassCastException e) {
            FailedMappingDto fmd = this.getFailedMappingDto(update, new IllegalArgumentException("The supplied update dto is not of the correct type to extract", e));
            fmd.timestamp = Instant.now();
            return List.of(fmd);
        }
        Instant instant2 = instant = dto.timestamp == null ? Instant.now() : dto.timestamp;
        if (dto.provider == null) {
            return List.of(this.copyCommonFields(dto, instant, this.getFailedMappingDto(dto, new IllegalArgumentException("No provider is defined"))));
        }
        if (dto.service == null) {
            return List.of(this.copyCommonFields(dto, instant, this.getFailedMappingDto(dto, new IllegalArgumentException("No service is defined"))));
        }
        if (dto.resource == null) {
            return List.of(this.copyCommonFields(dto, instant, this.getFailedMappingDto(dto, new IllegalArgumentException("No resource is defined"))));
        }
        ArrayList<DataUpdateDto> list = new ArrayList<DataUpdateDto>();
        if (dto.value != null || dto.nullAction != NullAction.IGNORE) {
            dud = this.copyCommonFields(dto, instant, new DataUpdateDto());
            if (dto.type != null) {
                dud.type = dto.type;
            }
            dud.data = dto.value;
            dud.actionOnDuplicate = dto.duplicateDataAction;
            list.add((DataUpdateDto)dud);
        }
        if (dto.metadata != null) {
            dud = this.copyCommonFields(dto, instant, new MetadataUpdateDto());
            ((MetadataUpdateDto)dud).metadata = dto.metadata;
            ((MetadataUpdateDto)dud).removeNullValues = true;
            ((MetadataUpdateDto)dud).actionOnDuplicate = dto.duplicateMetadataAction;
            list.add((DataUpdateDto)dud);
        }
        return list;
    }

    private FailedMappingDto getFailedMappingDto(Object originalDto, Throwable mappingFailure) {
        FailedMappingDto fmd = new FailedMappingDto();
        fmd.mappingFailure = mappingFailure;
        fmd.originalDto = originalDto;
        return fmd;
    }

    private <T extends AbstractUpdateDto> T copyCommonFields(GenericDto dto, Instant instant, T dud) {
        dud.modelPackageUri = dto.modelPackageUri;
        dud.model = dto.model;
        dud.provider = dto.provider;
        dud.service = dto.service;
        dud.resource = dto.resource;
        dud.timestamp = instant;
        dud.actionOnNull = dto.nullAction;
        dud.originalDto = dto;
        return dud;
    }
}

