/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.antlr.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.AbstractCriterion;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.SensiNactPath;

public class CriterionResourcePresence
extends AbstractCriterion {
    private final SensiNactPath rcPath;

    public CriterionResourcePresence(SensiNactPath rcPath) {
        this.rcPath = rcPath;
    }

    public String toString() {
        String content = String.format("(%s=*)", this.rcPath);
        if (this.isNegative()) {
            content = String.format("(!%s)", content);
        }
        return content;
    }

    @Override
    public ResourceValueFilter getResourceValueFilter() {
        Predicate<ResourceSnapshot> isSet = r -> {
            if (r.getValue() == null || r.getValue().getTimestamp() == null) {
                return false;
            }
            Object value = r.getValue().getValue();
            if (value == null) {
                return false;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) != 0;
            }
            if (value instanceof Collection) {
                return !((Collection)value).isEmpty();
            }
            return true;
        };
        if (this.isNegative()) {
            return (p, rs) -> rs.stream().anyMatch(r -> this.rcPath.accept((ResourceSnapshot)r) && !isSet.test((ResourceSnapshot)r));
        }
        return (p, rs) -> rs.stream().anyMatch(r -> this.rcPath.accept((ResourceSnapshot)r) && isSet.test((ResourceSnapshot)r));
    }
}

