/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.antlr.impl;

import java.text.Normalizer;
import java.util.regex.Pattern;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.IStringValue;

public class RegexString
implements IStringValue {
    private Pattern pattern;
    private final String strPattern;

    public RegexString(Pattern pattern) {
        this.pattern = pattern;
        this.strPattern = pattern.pattern();
    }

    public RegexString(String pattern) {
        this.strPattern = pattern;
    }

    @Override
    public boolean isRegex() {
        return true;
    }

    @Override
    public boolean matches(String other, boolean approximated) {
        String testedString;
        if (this.pattern == null) {
            this.pattern = Pattern.compile("^" + this.strPattern + "$", 2);
        }
        if (!approximated) {
            testedString = other;
        } else if (other != null) {
            testedString = Normalizer.normalize(other, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        } else {
            return false;
        }
        return this.pattern.matcher(testedString).matches();
    }

    @Override
    public String getString() {
        return null;
    }

    @Override
    public String getPattern() {
        return this.strPattern;
    }

    public String toString() {
        return String.format("{REGEX:%s}", this.strPattern);
    }
}

