/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.impl;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.northbound.filters.sensorthings.EFilterContext;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ResourceValueFilterInputHolder;

public class SensorthingsCriterion
implements ICriterion {
    private final EFilterContext context;
    private final Predicate<ResourceValueFilterInputHolder> predicate;

    public SensorthingsCriterion(EFilterContext context, Predicate<ResourceValueFilterInputHolder> predicate) {
        this.context = context;
        this.predicate = predicate;
    }

    public Predicate<GeoJsonObject> getLocationFilter() {
        return null;
    }

    public Predicate<ProviderSnapshot> getProviderFilter() {
        return null;
    }

    public Predicate<ServiceSnapshot> getServiceFilter() {
        return null;
    }

    public Predicate<ResourceSnapshot> getResourceFilter() {
        return null;
    }

    public ResourceValueFilter getResourceValueFilter() {
        switch (this.context) {
            case FEATURES_OF_INTEREST: 
            case HISTORICAL_LOCATIONS: 
            case LOCATIONS: 
            case THINGS: {
                return new ResourceValueFilter(){

                    public boolean test(ProviderSnapshot provider, List<ResourceSnapshot> resources) {
                        return SensorthingsCriterion.this.predicate.test(new ResourceValueFilterInputHolder(SensorthingsCriterion.this.context, provider, resources));
                    }
                };
            }
            case DATASTREAMS: 
            case OBSERVATIONS: 
            case OBSERVED_PROPERTIES: 
            case SENSORS: {
                return new ResourceValueFilter(){

                    public boolean test(ProviderSnapshot provider, List<ResourceSnapshot> resources) {
                        return resources.stream().map(r -> new ResourceValueFilterInputHolder(SensorthingsCriterion.this.context, provider, (ResourceSnapshot)r)).anyMatch(SensorthingsCriterion.this.predicate);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Filters are not supported in context of " + this.context);
    }
}

