/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.common.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.aries.tx.control.jdbc.common.impl.InternalJDBCConnectionProviderFactory;

public abstract class AbstractInternalJDBCConnectionProviderFactory
implements InternalJDBCConnectionProviderFactory {
    public static final String CONNECTION_TEST_QUERY = "aries.connection.test.query";

    protected DataSource poolIfNecessary(Map<String, Object> resourceProviderProperties, DataSource unpooled) {
        DataSource toUse;
        if (AbstractInternalJDBCConnectionProviderFactory.toBoolean(resourceProviderProperties, "osgi.connection.pooling.enabled", true)) {
            HikariConfig hcfg = new HikariConfig();
            hcfg.setDataSource(unpooled);
            hcfg.setMaximumPoolSize(AbstractInternalJDBCConnectionProviderFactory.toInt(resourceProviderProperties, "osgi.connection.max", 10));
            hcfg.setMinimumIdle(AbstractInternalJDBCConnectionProviderFactory.toInt(resourceProviderProperties, "osgi.connection.min", 10));
            hcfg.setConnectionTimeout(AbstractInternalJDBCConnectionProviderFactory.toLong(resourceProviderProperties, "osgi.connection.timeout", TimeUnit.SECONDS.toMillis(30L)));
            hcfg.setIdleTimeout(AbstractInternalJDBCConnectionProviderFactory.toLong(resourceProviderProperties, "osgi.idle.timeout", TimeUnit.MINUTES.toMillis(3L)));
            hcfg.setMaxLifetime(AbstractInternalJDBCConnectionProviderFactory.toLong(resourceProviderProperties, "osgi.connection.lifetime", TimeUnit.HOURS.toMillis(3L)));
            hcfg.setConnectionTestQuery(AbstractInternalJDBCConnectionProviderFactory.toString(resourceProviderProperties, CONNECTION_TEST_QUERY, null));
            toUse = new HikariDataSource(hcfg);
        } else {
            toUse = unpooled;
        }
        return toUse;
    }

    public static boolean toBoolean(Map<String, Object> props, String key, boolean defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        throw new IllegalArgumentException("The property " + key + " cannot be converted to a boolean");
    }

    public static int toInt(Map<String, Object> props, String key, int defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("The property " + key + " cannot be converted to an int");
    }

    public static long toLong(Map<String, Object> props, String key, long defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw new IllegalArgumentException("The property " + key + " cannot be converted to a long");
    }

    public static String toString(Map<String, Object> props, String key, String defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o == null) {
            return null;
        }
        return String.valueOf(o);
    }
}

