/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.resource.common.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.tx.control.resource.common.impl.LifecycleAware;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationDefinedResourceFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationDefinedResourceFactory.class);
    private final Map<String, LifecycleAware> managedInstances = new ConcurrentHashMap<String, LifecycleAware>();
    private final BundleContext context;

    public ConfigurationDefinedResourceFactory(BundleContext context) {
        this.context = context;
    }

    @Override
    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            propsMap.put(key, properties.get(key));
        }
        try {
            LifecycleAware cdr;
            LifecycleAware existing = this.managedInstances.get(pid);
            if (existing != null) {
                if (existing.update(propsMap)) {
                    LOG.debug("The Configuration driven resource with pid {} updated successfully", (Object)pid);
                    return;
                }
                this.closeCDR(pid, existing);
                cdr = this.getConfigurationDrivenResource(this.context, pid, propsMap);
                if (!this.managedInstances.replace(pid, existing, cdr)) {
                    return;
                }
            } else {
                cdr = this.getConfigurationDrivenResource(this.context, pid, propsMap);
                if (this.managedInstances.putIfAbsent(pid, cdr) != null) {
                    return;
                }
            }
            cdr.start();
        }
        catch (Exception e) {
            LOG.error("The configuration driven resource for pid {} encountered a failure", (Object)pid, (Object)e);
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)e;
            }
            throw new ConfigurationException(null, "A failure occured configuring the resource for pid " + pid, e);
        }
    }

    protected abstract LifecycleAware getConfigurationDrivenResource(BundleContext var1, String var2, Map<String, Object> var3) throws Exception;

    public void stop() {
        this.managedInstances.entrySet().forEach(e -> this.closeCDR((String)e.getKey(), (LifecycleAware)e.getValue()));
    }

    private void closeCDR(String pid, LifecycleAware cdr) {
        try {
            cdr.stop();
        }
        catch (Exception ex) {
            LOG.warn("There was an error stopping Configuration Driven Resource {}", (Object)pid, (Object)ex);
        }
    }

    @Override
    public void deleted(String pid) {
        Optional.ofNullable(this.managedInstances.remove(pid)).ifPresent(cdr -> this.closeCDR(pid, (LifecycleAware)cdr));
    }
}

