/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.felix.cm.json.Configurations;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationManager.class})
public class ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    @Reference
    ConfigurationAdmin configAdmin;
    WatchService watchService;
    ExecutorService executor;
    Path configFolder;
    Path configFile;
    private final AtomicBoolean expectedInterruption = new AtomicBoolean();
    private final AtomicReference<Thread> currentWatchThread = new AtomicReference();

    @Activate
    void start() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.configFolder = Paths.get(System.getProperty("sensinact.config.dir", "./config"), new String[0]);
        this.configFile = this.configFolder.resolve("configuration.json");
        LOGGER.info("Eclipse sensiNact is watching for changes in configuration file {}", (Object)this.configFile);
        this.configFolder.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.executor = Executors.newSingleThreadExecutor(this::createThread);
        this.executor.submit(this::reloadConfigFile);
        this.executor.submit(this::watch);
    }

    private Thread createThread(Runnable r) {
        Thread t = new Thread(r, "Configuration management thread");
        t.setDaemon(true);
        return t;
    }

    @Deactivate
    void stop() {
        LOGGER.info("Eclipse sensiNact configuration manager is stopping. Configurations will not be changed");
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error when stopping the configuration manager", (Throwable)e);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Error when stopping the configuration manager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void watch() {
        block16: {
            try {
                WatchKey key;
                this.currentWatchThread.set(Thread.currentThread());
                try {
                    key = this.watchService.take();
                }
                catch (ClosedWatchServiceException e) {
                    LOGGER.error("No longer able to monitor the configuration file {}", (Object)this.configFile, (Object)e);
                    this.currentWatchThread.set(null);
                    return;
                }
                catch (InterruptedException e) {
                    if (this.expectedInterruption.getAndSet(false)) {
                        LOGGER.debug("Forced configuration reload");
                        this.executor.submit(this::reloadConfigFile);
                        this.executor.submit(this::watch);
                    } else {
                        LOGGER.error("Interrupted while monitoring the configuration file {}", (Object)this.configFile, (Object)e);
                    }
                    this.currentWatchThread.set(null);
                    return;
                }
                for (WatchEvent<?> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.executor.submit(this::reloadConfigFile);
                        break;
                    }
                    if (!Files.isSameFile(this.configFile, this.configFolder.resolve((Path)watchEvent.context()))) continue;
                    this.executor.submit(this::reloadConfigFile);
                    break;
                }
                if (key.isValid()) {
                    key.reset();
                    this.executor.submit(this::watch);
                } else {
                    LOGGER.error("No longer able to monitor the configuration file {} as the key is invalid", (Object)this.configFile);
                }
                break block16;
                {
                    catch (Exception e) {
                        LOGGER.error("An unexpected error occurred watching the configuration file {}", (Object)this.configFile, (Object)e);
                        this.executor.submit(this::watch);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.currentWatchThread.set(null);
            }
        }
    }

    private ConfigurationResource loadConfigFile() throws IOException {
        ConfigurationResource config;
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.configFile);){
                ConfigurationReader configReader = Configurations.buildReader().withConfiguratorPropertyHandler((a, b, c) -> {}).build((Reader)reader);
                config = configReader.readConfigurationResource();
                for (String warning : configReader.getIgnoredErrors()) {
                    LOGGER.warn("Configuration file parsing warning. Error was\n{}", (Object)warning);
                }
            }
        } else {
            config = new ConfigurationResource();
        }
        return config;
    }

    private void reloadConfigFile() {
        try {
            ConfigurationResource config = this.loadConfigFile();
            Map existingConfigs = Optional.ofNullable(this.configAdmin.listConfigurations("(.sensinact.config=true)")).map(Arrays::stream).map(s -> s.collect(Collectors.toMap(Configuration::getPid, Function.identity()))).orElse(Map.of());
            for (Map.Entry e : config.getConfigurations().entrySet()) {
                String pid = (String)e.getKey();
                Hashtable value = (Hashtable)e.getValue();
                value.put(".sensinact.config", Boolean.TRUE);
                if (existingConfigs.containsKey(pid)) {
                    ((Configuration)existingConfigs.remove(pid)).updateIfDifferent((Dictionary)value);
                    continue;
                }
                this.createConfig(pid, value);
            }
            for (Configuration c : existingConfigs.values()) {
                c.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred parsing the configuration file {}", (Object)this.configFile, (Object)e);
        }
    }

    private void createConfig(String pid, Hashtable<String, Object> value) throws IOException {
        int idx = pid.indexOf(126);
        Configuration cfg = idx < 0 ? this.configAdmin.getConfiguration(pid, "?") : this.configAdmin.getFactoryConfiguration(pid.substring(0, idx), pid.substring(idx + 1), "?");
        cfg.update(value);
    }

    private Hashtable<String, Object> mergeConfigs(Map<String, Object> currentValues, Map<String, Object> defaultValues) {
        Hashtable<String, Object> newValues = new Hashtable<String, Object>();
        if (defaultValues != null) {
            newValues.putAll(defaultValues);
        }
        if (currentValues != null) {
            newValues.putAll(currentValues);
        }
        return newValues;
    }

    public void updateConfigurations(Map<String, Hashtable<String, Object>> newConfigurations, Collection<String> removedConfigurations) throws IOException {
        ConfigurationResource configResource = this.loadConfigFile();
        Map allConfigurations = configResource.getConfigurations();
        ArrayList orderedConfigKeys = new ArrayList(allConfigurations.keySet());
        Map configProperties = configResource.getProperties();
        if (configProperties.isEmpty()) {
            configResource.getProperties().put(":configurator:resource-version", 1);
            configResource.getProperties().put(":configurator:symbolic-name", "org.eclipse.sensinact.gateway.launcher");
            configResource.getProperties().put(":configurator:version", "0.0.1");
        }
        if (removedConfigurations != null) {
            removedConfigurations.stream().forEach(allConfigurations::remove);
            removedConfigurations.stream().filter(Predicate.not(newConfigurations::containsKey)).forEach(orderedConfigKeys::remove);
        }
        if (newConfigurations != null) {
            newConfigurations.keySet().stream().filter(Predicate.not(orderedConfigKeys::contains)).forEachOrdered(orderedConfigKeys::add);
            LinkedHashMap<String, Hashtable<String, Object>> mergedConfigs = new LinkedHashMap<String, Hashtable<String, Object>>(newConfigurations.size());
            for (String pid : orderedConfigKeys) {
                Hashtable<String, Object> newConfig = newConfigurations.get(pid);
                Hashtable rcConfigProps = (Hashtable)allConfigurations.get(pid);
                if (rcConfigProps == null) {
                    mergedConfigs.put(pid, newConfig);
                    continue;
                }
                LOGGER.debug("Reusing configuration properties for PID %s", (Object)pid);
                mergedConfigs.put(pid, this.mergeConfigs(rcConfigProps, newConfig));
            }
            allConfigurations.putAll(mergedConfigs);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFile, new OpenOption[0]);){
            Configurations.buildWriter().build((Writer)writer).writeConfigurationResource(configResource);
        }
        Thread watchThread = this.currentWatchThread.get();
        if (watchThread != null && this.expectedInterruption.compareAndSet(false, true)) {
            watchThread.interrupt();
        }
    }
}

