/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.sensinact.gateway.launcher.ConfigurationManager;
import org.eclipse.sensinact.gateway.launcher.FeatureLauncher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.opentest4j.AssertionFailedError;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.feature.FeatureService;

@ExtendWith(value={MockitoExtension.class})
class FeatureLaunchingTest {
    private static final String GROUP_ID = "org.eclipse.sensinact.gateway.launcher.test";
    @Mock
    BundleContext context;
    @Mock
    FeatureLauncher.Config config;
    @Mock
    ConfigurationManager manager;
    FeatureLauncher fl = new FeatureLauncher();
    private FeatureService fs;
    private List<Throwable> failures = new ArrayList<Throwable>();
    private Map<String, Bundle> installed = new HashMap<String, Bundle>();

    FeatureLaunchingTest() {
    }

    @BeforeEach
    void start() throws Exception {
        ServiceLoader<FeatureService> loader = ServiceLoader.load(FeatureService.class);
        this.fs = loader.findFirst().get();
        BundleRevision revMock = (BundleRevision)Mockito.mock(BundleRevision.class);
        Mockito.lenient().when((Object)revMock.getTypes()).thenReturn((Object)0);
        Mockito.lenient().when((Object)this.config.featureDir()).thenReturn((Object)new String[]{"src/test/resources/features"});
        Mockito.lenient().when((Object)this.config.repository()).thenReturn((Object)new String[]{"src/test/resources/repository"});
        Mockito.lenient().when((Object)this.context.installBundle(Mockito.anyString(), (InputStream)Mockito.any())).thenAnswer(i -> {
            String fromIs;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)i.getArgument(1, InputStream.class)));){
                fromIs = br.readLine();
            }
            try {
                Assertions.assertEquals((Object)i.getArgument(0, String.class), (Object)fromIs);
            }
            catch (AssertionFailedError e) {
                this.failures.add(e);
            }
            Bundle bundleMock = (Bundle)Mockito.mock(Bundle.class, (String)fromIs);
            Mockito.lenient().when((Object)((BundleRevision)bundleMock.adapt((Class)ArgumentMatchers.eq(BundleRevision.class)))).thenReturn((Object)revMock);
            this.installed.put(fromIs, bundleMock);
            return bundleMock;
        });
        this.fl.featureService = this.fs;
        this.fl.configManager = this.manager;
    }

    String getIdString(String groupId, String artifactId, String version, String type, String classifier) {
        if (classifier == null || classifier.isBlank()) {
            if (type == null || type.isBlank()) {
                return this.fs.getID(groupId, artifactId, version).toString();
            }
            return this.fs.getID(groupId, artifactId, version, type).toString();
        }
        return this.fs.getID(groupId, artifactId, version, type, classifier).toString();
    }

    @ParameterizedTest
    @CsvSource(value={"1.0.0,,,,", "1.0.0,feature,,bundle,", "1.0.0,json,feature,jar,bundle", "1.0.1,,,,", "1.0.1,feature,,bundle,", "1.0.1,json,feature,jar,bundle", "1.0.2-SNAPSHOT,,,,", "1.0.2-SNAPSHOT,feature,,bundle,", "1.0.2-SNAPSHOT,json,feature,jar,bundle"})
    void installFeatureWithMavenCoordinates(String version, String type, String classifier, String bundleType, String bundleClassifier) throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{this.getIdString(GROUP_ID, "fizz", version, type, classifier)});
        this.fl.start(this.context, this.config);
        Assertions.assertTrue((boolean)this.failures.isEmpty(), () -> this.failures.toString());
        String bundleId = this.getIdString(GROUP_ID, "buzz", version, bundleType, bundleClassifier);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
    }

    @Test
    void installFeatureSimpleName() throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"foo"});
        this.fl.start(this.context, this.config);
        Assertions.assertTrue((boolean)this.failures.isEmpty(), () -> this.failures.toString());
        String bundleId = this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null);
        String bundleId2 = this.getIdString(GROUP_ID, "buzz", "1.0.1", null, null);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId), this.installed.get(bundleId2)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).start();
    }

    @Test
    void cleanupOnStop() throws Exception {
        this.installFeatureSimpleName();
        this.fl.stop();
        Bundle bundle = this.installed.get(this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null));
        Bundle bundle2 = this.installed.get(this.getIdString(GROUP_ID, "buzz", "1.0.1", null, null));
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, bundle, bundle2});
        ((Bundle)order.verify((Object)bundle2)).stop();
        ((Bundle)order.verify((Object)bundle)).stop();
        ((Bundle)order.verify((Object)bundle2)).uninstall();
        ((Bundle)order.verify((Object)bundle)).uninstall();
        if (this.manager.configFile != null) {
            Files.deleteIfExists(this.manager.configFile);
            this.manager.configFile = null;
        }
    }

    @Test
    void installFeatureListedTwice() throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"foo", "foo"});
        this.fl.start(this.context, this.config);
        Assertions.assertTrue((boolean)this.failures.isEmpty(), () -> this.failures.toString());
        String bundleId = this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null);
        String bundleId2 = this.getIdString(GROUP_ID, "buzz", "1.0.1", null, null);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId), this.installed.get(bundleId2)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).start();
        order.verifyNoMoreInteractions();
    }

    @Test
    void installOverlappingFeatures() throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"foo", "foobar", "bar"});
        this.fl.start(this.context, this.config);
        Assertions.assertTrue((boolean)this.failures.isEmpty(), () -> this.failures.toString());
        String bundleId = this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null);
        String bundleId2 = this.getIdString(GROUP_ID, "buzz", "1.0.1", null, null);
        String bundleId3 = this.getIdString(GROUP_ID, "buzz", "1.0.2-SNAPSHOT", null, null);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId), this.installed.get(bundleId2), this.installed.get(bundleId3)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).start();
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId3), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).start();
        order.verifyNoMoreInteractions();
        this.fl.stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).uninstall();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).uninstall();
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).uninstall();
    }

    @Test
    void updateThatRemovesOverlappingFeatures() throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"foo", "foobar", "bar"});
        this.fl.start(this.context, this.config);
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"foo", "bar"});
        this.fl.update(this.config);
        Assertions.assertTrue((boolean)this.failures.isEmpty(), () -> this.failures.toString());
        String bundleId = this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null);
        String bundleId2 = this.getIdString(GROUP_ID, "buzz", "1.0.1", null, null);
        String bundleId3 = this.getIdString(GROUP_ID, "buzz", "1.0.2-SNAPSHOT", null, null);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId), this.installed.get(bundleId2), this.installed.get(bundleId3)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).start();
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId3), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).start();
        order.verifyNoMoreInteractions();
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"bar"});
        this.fl.update(this.config);
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).uninstall();
        order.verifyNoMoreInteractions();
        this.fl.stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).stop();
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).uninstall();
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).uninstall();
        order.verifyNoMoreInteractions();
    }

    class MapConfigArgumentMatcher
    implements ArgumentMatcher<Map<String, Hashtable<String, Object>>> {
        final Map<String, Hashtable<String, Object>> expected;

        MapConfigArgumentMatcher(Map<String, Hashtable<String, Object>> expected) {
            this.expected = expected;
        }

        public boolean matches(Map<String, Hashtable<String, Object>> arg) {
            if (!arg.keySet().equals(this.expected.keySet())) {
                return false;
            }
            for (String pid : arg.keySet()) {
                Hashtable<String, Object> expectedValues = this.expected.get(pid);
                Hashtable<String, Object> argValues = arg.get(pid);
                if (!argValues.keySet().equals(expectedValues.keySet())) {
                    System.out.println("Different keys");
                    return false;
                }
                for (String argKey : argValues.keySet()) {
                    Object argValue;
                    Object expectedValue = expectedValues.get(argKey);
                    if (Objects.equals(expectedValue, argValue = argValues.get(argKey)) || expectedValue instanceof Number && argValue instanceof Number && ((Number)expectedValue).longValue() == ((Number)argValue).longValue()) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.expected);
        }
    }

    @Nested
    class FeatureConfiguration {
        FeatureConfiguration() {
        }

        @Test
        void testFillInVariables() throws Exception {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("constant.str", "constant");
            values.put("constant.int", 1);
            values.put("var.missing", "${missing}");
            values.put("var.int", "${value.int}");
            values.put("var.combine", "${value.prefix}-${value.int}");
            values.put("var.semi-missing", "${value.prefix}-${missing}");
            FeatureLaunchingTest.this.fl.fillInVariables(values, Map.of("value.int", 42, "value.prefix", "hello"));
            Assertions.assertEquals((Object)"constant", values.get("constant.str"));
            Assertions.assertEquals((Object)1, values.get("constant.int"));
            Assertions.assertEquals((Object)"${missing}", values.get("var.missing"));
            Assertions.assertEquals((Object)42, values.get("var.int"));
            Assertions.assertEquals((Object)"hello-42", values.get("var.combine"));
            Assertions.assertEquals((Object)"hello-${missing}", values.get("var.semi-missing"));
        }

        @Test
        void testSimpleConfig() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"config_simple"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            String bundleId = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.2-SNAPSHOT", null, null);
            String bundleId2 = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.0", null, null);
            InOrder order = Mockito.inOrder((Object[])new Object[]{FeatureLaunchingTest.this.manager, FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.installed.get(bundleId), FeatureLaunchingTest.this.installed.get(bundleId2)});
            Map<String, Hashtable<String, Object>> expectedConfs = Map.of("test-A", new Hashtable<String, Integer>(Map.of("test", "A", "value", 42)), "test-merged", new Hashtable<String, Long>(Map.of("test", "merged", "value", 0, "value-A", 5L)));
            ((ConfigurationManager)order.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId))).start();
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId2))).start();
        }

        @Test
        void testConfigOnly() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"config_only"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            Map<String, Hashtable<String, Object>> expectedConfs = Map.of("test-only1", new Hashtable<String, Integer>(Map.of("test", "A", "value", 21)), "test-fixed", new Hashtable<String, Integer>(Map.of("test", "B", "value", 42)));
            ((ConfigurationManager)Mockito.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
            ((BundleContext)Mockito.verify((Object)FeatureLaunchingTest.this.context, (VerificationMode)Mockito.never())).installBundle((String)ArgumentMatchers.any());
        }

        @Test
        void testConfigUpdate() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"config_only"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            Map<String, Hashtable<String, Object>> expectedConfs = Map.of("test-only1", new Hashtable<String, Integer>(Map.of("test", "A", "value", 21)), "test-fixed", new Hashtable<String, Integer>(Map.of("test", "B", "value", 42)));
            ((ConfigurationManager)Mockito.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
            ((BundleContext)Mockito.verify((Object)FeatureLaunchingTest.this.context, (VerificationMode)Mockito.never())).installBundle((String)ArgumentMatchers.any());
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"config_only_update"});
            FeatureLaunchingTest.this.fl.update(FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            InOrder order = Mockito.inOrder((Object[])new Object[]{FeatureLaunchingTest.this.manager});
            expectedConfs = Map.of("test-only2", new Hashtable<String, Integer>(Map.of("test", "C", "value", 21)), "test-fixed", new Hashtable<String, Integer>(Map.of("test", "B", "value", 43)));
            ((ConfigurationManager)order.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.eq(null), (Collection)ArgumentMatchers.eq(Set.of("test-only1", "test-fixed")));
            ((ConfigurationManager)order.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
            ((BundleContext)Mockito.verify((Object)FeatureLaunchingTest.this.context, (VerificationMode)Mockito.never())).installBundle((String)ArgumentMatchers.any());
        }

        @Test
        void testConfigWithVars() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"config_vars"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            HashMap<String, Hashtable<String, Object>> expectedConfs = new HashMap<String, Hashtable<String, Object>>(Map.of("test-A", new Hashtable<String, Integer>(Map.of("test", "A", "value", 42)), "test-vars", new Hashtable<String, String>(Map.of("test", "vars", "value", 42, "text", "Hello_World", "missing", "${missing}"))));
            ((ConfigurationManager)Mockito.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
            ((BundleContext)Mockito.verify((Object)FeatureLaunchingTest.this.context, (VerificationMode)Mockito.never())).installBundle((String)ArgumentMatchers.any());
        }

        @Test
        void testConfigOverride() throws Exception {
            InOrder order = Mockito.inOrder((Object[])new Object[]{FeatureLaunchingTest.this.manager});
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"config_only", "config_only_2"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            Map<String, Hashtable<String, Object>> expectedConfs = Map.of("test-only1", new Hashtable<String, Integer>(Map.of("test", "A", "value", 21)), "test-fixed", new Hashtable<String, Integer>(Map.of("test", "B", "value", 42)));
            ((ConfigurationManager)order.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
            expectedConfs = Map.of("test-only2", new Hashtable<String, Integer>(Map.of("test", "Only2", "value", 15)), "test-fixed", new Hashtable<String, Integer>(Map.of("test", "Override", "value", 451)));
            ((ConfigurationManager)order.verify((Object)FeatureLaunchingTest.this.manager)).updateConfigurations((Map)ArgumentMatchers.argThat((ArgumentMatcher)new MapConfigArgumentMatcher(expectedConfs)), (Collection)ArgumentMatchers.eq(null));
        }

        @Test
        void testPathUserInjection() throws Exception {
            Path targetPath = Paths.get(System.getProperty("user.home"), "test");
            Assertions.assertEquals((Object)targetPath, (Object)FeatureLaunchingTest.this.fl.getPath(targetPath.toString()));
            Assertions.assertEquals((Object)targetPath, (Object)FeatureLaunchingTest.this.fl.getPath("~/test"));
        }

        @Test
        void testPathVariablesInjections() throws Exception {
            Path targetPath = Paths.get(System.getProperty("user.home"), "test");
            String homeEnv = null;
            for (String possibleHomeEnv : Arrays.asList("HOME", "USERPROFILE")) {
                if (System.getenv(possibleHomeEnv) == null) continue;
                homeEnv = possibleHomeEnv;
                break;
            }
            Assumptions.assumeTrue((homeEnv != null ? 1 : 0) != 0, (String)"No home environment variable found");
            Assertions.assertEquals((Object)targetPath, (Object)FeatureLaunchingTest.this.fl.getPath("${" + homeEnv + "}/test"));
        }
    }

    @Nested
    class FeatureDependencies {
        FeatureDependencies() {
        }

        @Test
        void testSingleDependencySatisfied() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"foo", "need_foo"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            String bundleId = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.0", null, null);
            String bundleId2 = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.1", null, null);
            String bundleId3 = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.2-SNAPSHOT", null, null);
            InOrder order = Mockito.inOrder((Object[])new Object[]{FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.installed.get(bundleId), FeatureLaunchingTest.this.installed.get(bundleId2), FeatureLaunchingTest.this.installed.get(bundleId3)});
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId))).start();
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId2))).start();
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId3), (InputStream)ArgumentMatchers.any());
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId3))).start();
        }

        @Test
        void testSingleDependencySatisfiedMavenCoords() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"org.eclipse.sensinact.gateway.launcher.test:fizz:1.0.0", "need_fizz"});
            FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config);
            Assertions.assertTrue((boolean)FeatureLaunchingTest.this.failures.isEmpty(), () -> FeatureLaunchingTest.this.failures.toString());
            String bundleId = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.0", null, null);
            String bundleId2 = FeatureLaunchingTest.this.getIdString(FeatureLaunchingTest.GROUP_ID, "buzz", "1.0.1", null, null);
            InOrder order = Mockito.inOrder((Object[])new Object[]{FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.installed.get(bundleId), FeatureLaunchingTest.this.installed.get(bundleId2)});
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId))).start();
            ((BundleContext)order.verify((Object)FeatureLaunchingTest.this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
            ((Bundle)order.verify((Object)FeatureLaunchingTest.this.installed.get(bundleId2))).start();
        }

        @Test
        void testSingleDependencyNotSatisfied() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"need_foo"});
            ConfigurationException exception = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config));
            Assertions.assertEquals((Object)"features", (Object)exception.getProperty());
        }

        @Test
        void testSingleDependencyWrongOrder() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"need_foo", "foo"});
            ConfigurationException exception = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config));
            Assertions.assertEquals((Object)"features", (Object)exception.getProperty());
        }

        @Test
        void testDependencyWrongType() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"bad_depends_type"});
            ConfigurationException exception = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config));
            Assertions.assertEquals((Object)"features", (Object)exception.getProperty());
        }

        @Test
        void testDependencyUnknownMandatoryExtension() throws Exception {
            Mockito.when((Object)FeatureLaunchingTest.this.config.features()).thenReturn((Object)new String[]{"unkown_extension"});
            ConfigurationException exception = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> FeatureLaunchingTest.this.fl.start(FeatureLaunchingTest.this.context, FeatureLaunchingTest.this.config));
            Assertions.assertEquals((Object)"features", (Object)exception.getProperty());
        }
    }
}

