/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.xml;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLUtil {
    public static void parse(ContentHandler handler, URL schema, String xml) throws ParserConfigurationException, SAXException, IOException {
        XMLUtil.parse(handler, schema, new InputSource(xml));
    }

    public static void parse(ContentHandler handler, URL schema, InputSource xml) throws ParserConfigurationException, SAXException, IOException {
        if (handler == null) {
            throw new SAXException("Null ContentHandler");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (schema != null) {
            factory.setNamespaceAware(true);
            factory.setValidating(true);
        }
        SAXParser parser = factory.newSAXParser();
        if (schema != null) {
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schema.toExternalForm());
        }
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.parse(xml);
    }

    public static String createTag(String prefix, String tag, String[][] attributes, Object content) {
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append(XMLUtil.openTag(prefix, tag, attributes));
        tagBuilder.append(content);
        tagBuilder.append(XMLUtil.closeTag(prefix, tag));
        return tagBuilder.toString();
    }

    public static String openTag(String prefix, String tag, String[][] attributes) {
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("<");
        tagBuilder.append(prefix != null && prefix.length() > 0 ? prefix : "");
        tagBuilder.append(prefix != null && prefix.length() > 0 ? ":" : "");
        tagBuilder.append(tag);
        if (attributes != null) {
            for (int index = 0; index < attributes.length; ++index) {
                tagBuilder.append(" ");
                tagBuilder.append(attributes[index][0]);
                tagBuilder.append("=\"");
                tagBuilder.append(attributes[index][1]);
                tagBuilder.append("\"");
            }
        }
        tagBuilder.append(">");
        return tagBuilder.toString();
    }

    public static String closeTag(String prefix, String tag) {
        StringBuilder tagBuilder = new StringBuilder();
        tagBuilder.append("</");
        tagBuilder.append(prefix != null && prefix.length() > 0 ? prefix : "");
        tagBuilder.append(prefix != null && prefix.length() > 0 ? ":" : "");
        tagBuilder.append(tag);
        tagBuilder.append(">");
        return tagBuilder.toString();
    }
}

