/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskCallBack;
import org.eclipse.sensinact.gateway.generic.TaskDesynchronizer;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManager.class);
    public static final char IDENTIFIER_SEP_CHAR = '#';
    private final Object lock = new Object();
    protected final Deque<Task> waitingTasks;
    protected final Map<String, List<Task>> executedTasks;
    protected TaskDesynchronizer desynchronizer;
    protected final TaskTranslator connector;

    public TaskManager(TaskTranslator connector, boolean initialLockState, boolean isDesynchronized) {
        this.connector = connector;
        this.waitingTasks = new LinkedList<Task>();
        this.executedTasks = new HashMap<String, List<Task>>();
        if (isDesynchronized) {
            this.desynchronizer = new TaskDesynchronizer();
            this.desynchronizer.setLocked(initialLockState);
            new Thread(this.desynchronizer).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextTask() {
        Task task = null;
        Object object = this.waitingTasks;
        synchronized (object) {
            if (!this.waitingTasks.isEmpty()) {
                task = this.waitingTasks.poll();
            }
        }
        if (task != null) {
            if (!task.isResultAvailable()) {
                String taskIdentifier = task.getTaskIdentifier();
                if (taskIdentifier != null) {
                    this.add(UriUtils.getRoot((String)task.getPath()).substring(1), task);
                }
                task.execute();
                if (taskIdentifier == null) {
                    task.abort(AccessMethod.EMPTY);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No task left to execute");
        }
        object = this.lock;
        synchronized (object) {
            if (this.desynchronizer != null) {
                this.desynchronizer.freeingToken();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Task> remove(String taskIdentifier) {
        if (taskIdentifier == null) {
            return Collections.emptyList();
        }
        int index = taskIdentifier.indexOf(35);
        if (index == -1) {
            return Collections.emptyList();
        }
        String serviceProviderIdentifier = taskIdentifier.substring(0, index);
        ArrayList<Task> tasks = new ArrayList<Task>();
        Map<String, List<Task>> map = this.executedTasks;
        synchronized (map) {
            List<Task> executeds = this.executedTasks.get(serviceProviderIdentifier);
            if (executeds == null) {
                return tasks;
            }
            Iterator<Task> iterator = executeds.iterator();
            while (iterator.hasNext()) {
                Task task = iterator.next();
                if (!taskIdentifier.equals(task.getTaskIdentifier())) continue;
                iterator.remove();
                tasks.add(task);
            }
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String serviceProviderIdentifier, Task task) {
        List<Task> tasks = null;
        Map<String, List<Task>> map = this.executedTasks;
        synchronized (map) {
            tasks = this.executedTasks.get(serviceProviderIdentifier);
            if (tasks == null) {
                tasks = new ArrayList<Task>();
                this.executedTasks.put(serviceProviderIdentifier, tasks);
            }
            tasks.add(task);
            task.registerCallBack(new TaskCallBack(new Executable<Task, Void>(){

                public Void execute(Task task) throws Exception {
                    TaskManager.this.remove(task.getTaskIdentifier());
                    return null;
                }
            }));
        }
    }

    public Task execute(Task.CommandType command, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        Task task = null;
        switch (command) {
            case GET: {
                task = this.connector.createTask(Task.CommandType.GET, path, profileId, resourceConfig, parameters);
                break;
            }
            case SET: {
                task = this.connector.createTask(Task.CommandType.SET, path, profileId, resourceConfig, parameters);
                break;
            }
            case ACT: {
                task = this.connector.createTask(Task.CommandType.ACT, path, profileId, resourceConfig, parameters);
                break;
            }
            case SUBSCRIBE: {
                task = this.connector.createTask(Task.CommandType.SUBSCRIBE, path, profileId, resourceConfig, parameters);
                break;
            }
            case UNSUBSCRIBE: {
                task = this.connector.createTask(Task.CommandType.UNSUBSCRIBE, path, profileId, resourceConfig, parameters);
                break;
            }
            case SERVICES_ENUMERATION: {
                task = this.connector.createTask(Task.CommandType.SERVICES_ENUMERATION, path, profileId, resourceConfig, parameters);
                break;
            }
        }
        if (task != null) {
            return this.execute(task);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task execute(Task task) {
        Object object = this.waitingTasks;
        synchronized (object) {
            this.waitingTasks.offer(task);
        }
        object = this.lock;
        synchronized (object) {
            if (this.desynchronizer == null) {
                this.nextTask();
            } else {
                this.desynchronizer.require(this);
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Deque<Task> deque = this.lock;
        synchronized (deque) {
            if (this.desynchronizer != null) {
                this.desynchronizer.stop();
                this.desynchronizer = null;
            }
        }
        deque = this.waitingTasks;
        synchronized (deque) {
            this.waitingTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.desynchronizer != null) {
                this.desynchronizer.freeingToken();
            }
        }
    }
}

