/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.annotation;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.annotation.InjectedService;
import org.eclipse.sensinact.gateway.generic.annotation.TaskExecution;
import org.eclipse.sensinact.gateway.generic.annotation.TaskInject;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationResolver
implements Iterable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationResolver.class);
    private final Mediator mediator;
    private List<Object> instances;
    private Map<Class<?>, Object> injected;

    public AnnotationResolver(Mediator mediator) {
        this.mediator = mediator;
        this.injected = new HashMap();
        this.buildInstances(mediator.getContext().getBundle());
    }

    private void buildInstances(Bundle bundle) {
        this.instances = new ArrayList<Object>();
        if (bundle == null) {
            return;
        }
        Enumeration urls = bundle.findEntries("/", "*.class", true);
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            String path;
            URL url = (URL)urls.nextElement();
            path = path.substring((path = url.getPath().replaceAll("\\/|\\$", ".")).startsWith(".") ? 1 : 0, path.length() - 6);
            try {
                Object instance;
                Class loaded = bundle.loadClass(path);
                if (loaded.getAnnotation(TaskExecution.class) == null || (instance = ReflectUtils.getTheBestInstance((Class)loaded, (Object[])new Object[]{this.mediator})) == null) continue;
                this.instances.add(instance);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    public void buildInjected() {
        for (Object instance : this.instances) {
            Map fieldsMap = ReflectUtils.getAnnotatedFields(instance.getClass(), TaskInject.class);
            Set fields = fieldsMap.keySet();
            if (fields.isEmpty()) continue;
            for (Field field : fields) {
                field.setAccessible(true);
                if ((field.getModifiers() & 0x10) == 16) continue;
                Class<?> type = field.getType();
                Object value = null;
                value = this.injected.get(type);
                if (value == null) {
                    block11: {
                        boolean defaultInjectedService = true;
                        String filter = ((TaskInject)fieldsMap.get(field)).filter();
                        String completeFilter = null;
                        if (filter == null || "#NO_FILTER#".equals(filter)) {
                            defaultInjectedService = false;
                        } else {
                            completeFilter = filter;
                        }
                        try {
                            value = new InjectedService(this.mediator, type, completeFilter);
                            if (!((InjectedService)value).exists() && !defaultInjectedService) {
                                value = null;
                            }
                        }
                        catch (InvalidSyntaxException e) {
                            if (!LOG.isDebugEnabled()) break block11;
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (value != null || (value = ReflectUtils.getTheBestInstance(type, (Object[])new Object[]{this.mediator})) != null) {
                        this.injected.put(type, value);
                    }
                }
                if (value == null) continue;
                try {
                    field.set(instance, value);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public <T> void addInjectableInstance(Class<T> injectableType, T injectable) {
        this.injected.put(injectableType, injectable);
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.instances).iterator();
    }
}

