/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.generic.parser.TypeDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;
import org.xml.sax.Attributes;

@XmlAttributes(value={@XmlAttribute(attribute="value", field="value"), @XmlAttribute(attribute="reference", field="reference"), @XmlAttribute(attribute="complement", field="complement")})
public class ConstraintDefinition
extends XmlModelParsingContext
implements JSONable {
    private String value;
    private String reference;
    private boolean complement;
    private final String name;
    private TypeDefinition<Class<?>> typeDefinition;

    public ConstraintDefinition(Mediator mediator, String name, Attributes atts) {
        super(mediator, atts);
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setComplement(String complement) {
        this.complement = Boolean.parseBoolean(complement);
    }

    public void setType(TypeDefinition<Class<?>> typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Constraint getConstraint(Class<?> clazz) throws InvalidConstraintDefinitionException {
        Object[] objectArray;
        ClassLoader classLoader = this.mediator.getClassLoader();
        if (this.reference != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.value;
            objectArray = objectArray2;
            objectArray2[1] = this.reference;
        } else {
            objectArray = this.value;
        }
        Constraint constraint = ConstraintFactory.Loader.load((ClassLoader)classLoader, (String)this.name, clazz, (Object)objectArray, (boolean)this.complement);
        return constraint;
    }

    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("operator");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.name);
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("type");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(CastUtils.writeClass(this.typeDefinition.getType()));
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("operand");
        builder.append('\"');
        builder.append(':');
        if (this.reference != null) {
            builder.append('[');
            builder.append(JSONUtils.toJSONFormat((Object)this.value));
            builder.append(',');
            builder.append(JSONUtils.toJSONFormat((Object)this.reference));
            builder.append(']');
        } else {
            builder.append(JSONUtils.toJSONFormat((Object)this.value));
        }
        builder.append(',');
        builder.append('\"');
        builder.append("complement");
        builder.append('\"');
        builder.append(':');
        builder.append(this.complement);
        builder.append('}');
        return builder.toString();
    }
}

