/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.access.impl;

import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.core.security.AbstractUserUpdater;
import org.eclipse.sensinact.gateway.core.security.SecuredAccessException;
import org.eclipse.sensinact.gateway.core.security.SecurityDataStoreService;
import org.eclipse.sensinact.gateway.core.security.User;
import org.eclipse.sensinact.gateway.core.security.UserManager;
import org.eclipse.sensinact.gateway.core.security.UserManagerFinalizer;
import org.eclipse.sensinact.gateway.core.security.UserUpdater;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.dao.UserDAO;
import org.eclipse.sensinact.gateway.core.security.entity.UserEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.eclipse.sensinact.gateway.util.CryptoUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component
public class UserManagerImpl
implements UserManager {
    private UserDAO userDAO;
    private UserEntity anonymous;
    @Reference
    private SecurityDataStoreService dataStoreService;
    @Reference(service=LoggerFactory.class)
    private Logger logger;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private volatile List<UserManagerFinalizer> userManagerFinalizers;
    @Activate
    private BundleContext context;

    @Activate
    public UserManagerImpl() throws SecuredAccessException {
        this.userDAO = new UserDAO((DataStoreService)this.dataStoreService);
        try {
            this.anonymous = this.userDAO.find(0L);
        }
        catch (IllegalArgumentException | NullPointerException | DataStoreException e) {
            this.logger.error("Could not load anonymous user for %s", (Object)0L, (Object)e);
            throw new SecuredAccessException(e);
        }
    }

    public boolean loginExists(String login) throws SecuredAccessException, DataStoreException {
        return this.userDAO.select(Collections.singletonMap("SULOGIN", login)).size() > 0;
    }

    public boolean accountExists(String account) throws SecuredAccessException, DataStoreException {
        return this.userDAO.findFromAccount(account) != null;
    }

    public User getUser(String login, String password) throws SecuredAccessException, DataStoreException {
        return this.userDAO.find(login, password);
    }

    public User getUserFromPublicKey(String publicKey) throws SecuredAccessException, DataStoreException {
        if (publicKey == null) {
            return this.anonymous;
        }
        return this.userDAO.find(publicKey);
    }

    public User getUserFromAccount(String account) throws SecuredAccessException, DataStoreException {
        if (account == null) {
            return this.anonymous;
        }
        return this.userDAO.findFromAccount(account);
    }

    public UserUpdater createUser(String token, final String login, final String password, final String account, final String accountType) throws SecuredAccessException {
        return new AbstractUserUpdater(token, "create"){

            public String getAccount() {
                return account;
            }

            public String getAccountType() {
                return accountType;
            }

            protected String doUpdate() throws SecuredAccessException {
                String publicKeyStr = login + ":" + account + System.currentTimeMillis();
                try {
                    String publicKey = CryptoUtils.cryptWithMD5((String)publicKeyStr);
                    UserEntity user = new UserEntity(login, password, account, accountType, publicKey);
                    UserManagerImpl.this.userDAO.create(user);
                    for (UserManagerFinalizer f : UserManagerImpl.this.userManagerFinalizers) {
                        f.userCreated(login, publicKey, account, accountType);
                    }
                    return "Public Key : " + publicKey;
                }
                catch (InvalidKeyException | DAOException | DataStoreException e) {
                    throw new SecuredAccessException((Throwable)e);
                }
            }
        };
    }

    public UserUpdater renewUserPassword(String token, final String account, final String accountType) throws SecuredAccessException {
        return new AbstractUserUpdater(token, "renew"){
            static final String ALPHABET = ".!0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

            public String getAccount() {
                return account;
            }

            public String getAccountType() {
                return accountType;
            }

            protected String doUpdate() throws SecuredAccessException {
                try {
                    User user = UserManagerImpl.this.getUserFromAccount(account);
                    StringBuilder builder = new StringBuilder();
                    do {
                        String millis = String.valueOf(System.currentTimeMillis());
                        for (int i = millis.length() - 1; i > 6; --i) {
                            int val = Integer.parseInt(millis.substring(i - 1, i + 1));
                            int hval = Integer.parseInt(millis.substring(i - 1, i + 1), 16);
                            int index = -1;
                            index = ALPHABET.indexOf(val);
                            if (index > -1) {
                                builder.append(ALPHABET.substring(index, index + 1));
                                continue;
                            }
                            index = ALPHABET.indexOf(hval);
                            if (index > -1) {
                                builder.append(ALPHABET.substring(index, index + 1));
                                continue;
                            }
                            if (val < millis.length()) {
                                builder.append(ALPHABET.substring(val, val + 1));
                                continue;
                            }
                            if (hval >= millis.length()) continue;
                            builder.append(ALPHABET.substring(hval, hval + 1));
                        }
                        Thread.sleep(345L);
                    } while (builder.length() <= 10);
                    String password = builder.toString();
                    String encryptedPassword = CryptoUtils.cryptWithMD5((String)password);
                    ((UserEntity)user).setPassword(encryptedPassword);
                    UserManagerImpl.this.userDAO.update((UserEntity)user);
                    return "Your new password : " + password;
                }
                catch (InterruptedException | InvalidKeyException | DAOException | DataStoreException e) {
                    throw new SecuredAccessException((Throwable)e);
                }
            }
        };
    }

    public void updateField(User user, String fieldName, Object oldValue, Object newValue) throws SecuredAccessException {
        try {
            Class<?> clazz = user.getClass();
            String getPrefix = "get";
            String setPrefix = "set";
            String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getMethod = clazz.getMethod(getPrefix + suffix, new Class[0]);
            Object current = getMethod.invoke((Object)user, new Object[0]);
            if (current == null && oldValue != null || current != null && !current.equals(oldValue)) {
                throw new SecuredAccessException("Invalid current value");
            }
            Method setMethod = clazz.getMethod(setPrefix + suffix, newValue.getClass());
            setMethod.invoke((Object)user, newValue);
        }
        catch (Exception e) {
            throw new SecuredAccessException((Throwable)e);
        }
    }
}

