/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Column;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.ForeignKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.NotNull;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.PrimaryKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Table;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnaEntity {
    private static final Logger LOG = LoggerFactory.getLogger(SnaEntity.class);
    private static final Map<Class<? extends SnaEntity>, Map<Field, Column>> FIELDS_MAP = new HashMap<Class<? extends SnaEntity>, Map<Field, Column>>();
    protected List<Key> keys;

    public static <E extends SnaEntity> Map<Field, Column> getFields(Class<E> entityType) {
        Map fields = FIELDS_MAP.get(entityType);
        if (fields == null) {
            fields = ReflectUtils.getAnnotatedFields(entityType, Column.class);
            FIELDS_MAP.put(entityType, fields);
        }
        return fields;
    }

    private static final <E extends SnaEntity> Field getUniqueFieldPrimaryKey(E entity) {
        Class<?> entityType = entity.getClass();
        PrimaryKey primaryKey = entityType.getAnnotation(PrimaryKey.class);
        String[] columns = null;
        if (primaryKey == null || (columns = primaryKey.value()).length != 1) {
            return null;
        }
        Map<Field, Column> fields = SnaEntity.getFields(entityType);
        for (Map.Entry<Field, Column> entry : fields.entrySet()) {
            if (!columns[0].equals(entry.getValue().value())) continue;
            Field field = entry.getKey();
            return field;
        }
        return null;
    }

    public static <E extends SnaEntity> long getUniqueLongPrimaryKey(E entity) {
        Field field = SnaEntity.getUniqueFieldPrimaryKey(entity);
        if (field != null) {
            try {
                field.setAccessible(true);
                return (Long)CastUtils.cast(Long.TYPE, (Object)field.get(entity));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        return -1L;
    }

    public static <E extends SnaEntity> boolean setUniqueLongPrimaryKey(E entity, long identifier) {
        Field field = SnaEntity.getUniqueFieldPrimaryKey(entity);
        if (field != null) {
            try {
                field.setAccessible(true);
                field.set(entity, identifier);
                return true;
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        return false;
    }

    protected SnaEntity() {
        Map<Field, Column> fields = SnaEntity.getFields(this.getClass());
        this.keys = this.createKeyList(this.getClass().getAnnotation(PrimaryKey.class), fields);
    }

    protected SnaEntity(JSONObject row) {
        this();
        if (JSONObject.NULL.equals(row)) {
            return;
        }
        Table table = this.getClass().getAnnotation(Table.class);
        Map<Field, Column> fields = SnaEntity.getFields(this.getClass());
        for (Map.Entry<Field, Column> entry : fields.entrySet()) {
            String rowColumn = entry.getValue().value();
            String column = table.value() + "." + rowColumn;
            if (row.has(column)) {
                this.setFieldValue(entry.getKey(), row.get(column));
                continue;
            }
            if (!row.has(rowColumn)) continue;
            this.setFieldValue(entry.getKey(), row.get(rowColumn));
        }
    }

    public List<Key> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    protected List<Key> createKeyList(PrimaryKey primaryKey, Map<Field, Column> fields) {
        int length;
        ArrayList<Key> keyMap = new ArrayList<Key>();
        String[] keys = primaryKey == null ? null : primaryKey.value();
        int n = length = keys == null ? 0 : keys.length;
        if (length == 0) {
            return keyMap;
        }
        for (Map.Entry<Field, Column> entry : fields.entrySet()) {
            int index;
            String column = entry.getValue().value();
            for (index = 0; index < length && !keys[index].equals(column); ++index) {
            }
            if (index == length) continue;
            keyMap.add(new Key(entry.getKey()));
        }
        return keyMap;
    }

    public Object getFieldValue(String field) {
        if (field == null || field.length() == 0) {
            return null;
        }
        Map<Field, Column> fields = SnaEntity.getFields(this.getClass());
        for (Map.Entry<Field, Column> entry : fields.entrySet()) {
            if (!field.equals(entry.getValue().value())) continue;
            return this.getFieldValue(entry.getKey());
        }
        return null;
    }

    public Object getFieldValue(Field field) {
        Object object = null;
        try {
            field.setAccessible(true);
            object = field.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return object;
    }

    protected void setFieldValue(Field field, Object value) {
        Method method = null;
        try {
            method = this.getMethod(this.getMethodName(field.getName(), "set"), field.getType());
            if (method != null) {
                method.invoke((Object)this, CastUtils.cast(field.getType(), (Object)value));
            } else {
                field.setAccessible(true);
                field.set(this, CastUtils.cast(field.getType(), (Object)value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Method getMethod(String methodName, Class<?> fieldType) {
        try {
            return this.getClass().getDeclaredMethod(methodName, fieldType);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getMethodName(String fieldName, String prefix) {
        String firstUpper = fieldName.substring(0, 1).toUpperCase();
        String methodName = prefix + firstUpper + fieldName.substring(1);
        return methodName;
    }

    public class Key
    implements Nameable {
        private Field field;
        private String localColumn;
        private String foreignColumn;
        private boolean foreignKey;
        private boolean nullable;

        public Key(Field field) {
            Table table = SnaEntity.this.getClass().getAnnotation(Table.class);
            ForeignKey foreignKey = field.getAnnotation(ForeignKey.class);
            Column column = field.getAnnotation(Column.class);
            this.nullable = field.getAnnotation(NotNull.class) != null;
            this.foreignKey = foreignKey != null;
            this.localColumn = table.value() + "." + column.value();
            if (this.foreignKey) {
                this.foreignColumn = foreignKey.table() + "." + foreignKey.refer();
            }
            this.field = field;
        }

        public long value() {
            Object object = SnaEntity.this.getFieldValue(this.field);
            if (object == null) {
                return -1L;
            }
            return (Long)object;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getName() {
            if (this.foreignKey) {
                return this.foreignColumn;
            }
            return this.localColumn;
        }
    }
}

