/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.packet;

import java.io.ByteArrayOutputStream;
import java.util.Map;

public interface PayloadDecoder {
    public Map<String, Object> decodeRawPayload(String var1);

    public static class Base64BinaryDecoder {
        private static final byte PADDING = 127;
        private static final byte[] decodeMap = new byte[128];

        private static int length(String text) {
            int padSize;
            int j;
            int len = text.length();
            for (j = len - 1; j >= 0; --j) {
                byte code = decodeMap[text.charAt(j)];
                if (code == 127) {
                    continue;
                }
                if (code != -1) break;
                return text.length() / 4 * 3;
            }
            if ((padSize = len - ++j) > 2) {
                return text.length() / 4 * 3;
            }
            return text.length() / 4 * 3 - padSize;
        }

        public static byte[] parseBase64Binary(String text) {
            int buflen = Base64BinaryDecoder.length(text);
            byte[] out = new byte[buflen];
            int o = 0;
            int len = text.length();
            byte[] quadruplet = new byte[4];
            int q = 0;
            for (int i = 0; i < len; ++i) {
                char ch = text.charAt(i);
                byte v = decodeMap[ch];
                if (v != -1) {
                    quadruplet[q++] = v;
                }
                if (q != 4) continue;
                out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
                if (quadruplet[2] != 127) {
                    out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
                }
                if (quadruplet[3] != 127) {
                    out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
                }
                q = 0;
            }
            if (buflen == o) {
                return out;
            }
            byte[] nb = new byte[o];
            System.arraycopy(out, 0, nb, 0, o);
            return nb;
        }

        static {
            String RAW = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
            byte[] map = new byte[128];
            for (int i = 0; i < 128; ++i) {
                map[i] = (byte)RAW.indexOf(i);
            }
            map[61] = 127;
            System.arraycopy(map, 0, decodeMap, 0, 128);
        }
    }

    public static class HexDecoder {
        private static final byte[] encodingTable;

        public static String toHexString(byte[] data) {
            int length = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < length; ++i) {
                int v = data[i] & 0xFF;
                out.write(encodingTable[v >>> 4]);
                out.write(encodingTable[v & 0xF]);
            }
            byte[] bytes = out.toByteArray();
            char[] chars = new char[bytes.length];
            for (int i = 0; i != chars.length; ++i) {
                chars[i] = (char)(bytes[i] & 0xFF);
            }
            return new String(chars);
        }

        static {
            String encodingString = "0123456789abcdef";
            encodingTable = new byte[encodingString.length()];
            for (int n = 0; n < encodingString.length(); ++n) {
                HexDecoder.encodingTable[n] = (byte)encodingString.charAt(n);
            }
        }
    }
}

