/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.publish;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.rsa.discovery.zookeeper.repository.ZookeeperEndpointRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingEndpointListener
implements EndpointEventListener,
EndpointListener {
    private static final Logger LOG = LoggerFactory.getLogger(PublishingEndpointListener.class);
    private ServiceRegistration<?> listenerReg;
    private ZookeeperEndpointRepository repository;

    public PublishingEndpointListener(ZookeeperEndpointRepository repository) {
        this.repository = repository;
    }

    public void start(BundleContext bctx) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        String uuid = bctx.getProperty("org.osgi.framework.uuid");
        ((Dictionary)props).put("endpoint.listener.scope", String.format("(&(%s=*)(%s=%s))", "objectClass", "endpoint.framework.uuid", uuid));
        ((Dictionary)props).put("org.apache.cxf.dosgi.discovery.zookeeper", "true");
        String[] ifAr = new String[]{EndpointEventListener.class.getName(), EndpointListener.class.getName()};
        this.listenerReg = bctx.registerService(ifAr, (Object)this, props);
    }

    public void stop() {
        if (this.listenerReg != null) {
            this.listenerReg.unregister();
            this.listenerReg = null;
        }
    }

    public void endpointChanged(EndpointEvent event, String filter) {
        EndpointDescription endpoint = event.getEndpoint();
        switch (event.getType()) {
            case 1: {
                this.endpointAdded(endpoint, filter);
                break;
            }
            case 2: {
                this.endpointRemoved(endpoint, filter);
                break;
            }
            case 4: {
                this.endpointModified(endpoint, filter);
            }
        }
    }

    private void endpointModified(EndpointDescription endpoint, String filter) {
        try {
            this.repository.modify(endpoint);
        }
        catch (Exception ex) {
            this.logException("modification", endpoint, ex);
        }
    }

    public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
        try {
            this.repository.add(endpoint);
        }
        catch (Exception ex) {
            this.logException("adding", endpoint, ex);
        }
    }

    public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
        try {
            this.repository.remove(endpoint);
        }
        catch (Exception ex) {
            this.logException("removal", endpoint, ex);
        }
    }

    private void logException(String operation, EndpointDescription endpoint, Exception ex) {
        String msg = String.format("Exception during %s of endpoint %s", operation, endpoint.getId());
        LOG.error(msg, (Throwable)ex);
    }
}

