/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.rsa.provider.fastbin.Activator;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.streams.InputStreamProxy;
import org.apache.aries.rsa.provider.fastbin.streams.OutputStreamProxy;
import org.apache.aries.rsa.provider.fastbin.tcp.InvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.ResponseFuture;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInvocationStrategy
implements InvocationStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractInvocationStrategy.class);

    @Override
    public ResponseFuture request(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args, DataByteArrayOutputStream requestStream) throws Exception {
        this.replaceStreamParameters(method, args);
        this.encodeRequest(serializationStrategy, loader, method, args, requestStream);
        return this.createResponse(serializationStrategy, loader, method, args);
    }

    protected void replaceStreamParameters(Method method, Object[] args) {
        Class<?>[] types = method.getParameterTypes();
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!this.isStream(types[i])) continue;
            args[i] = this.replaceStream(args[i]);
        }
    }

    protected Object replaceStream(Object value) {
        if (value instanceof InputStream) {
            InputStream in = (InputStream)value;
            int streamID = Activator.getInstance().getServer().getStreamProvider().registerStream(in);
            value = new InputStreamProxy(streamID, Activator.getInstance().getServer().getConnectAddress());
        } else if (value instanceof OutputStream) {
            OutputStream out = (OutputStream)value;
            int streamID = Activator.getInstance().getServer().getStreamProvider().registerStream(out);
            value = new OutputStreamProxy(streamID, Activator.getInstance().getServer().getConnectAddress());
        }
        return value;
    }

    protected boolean isStream(Class<?> clazz) {
        return clazz == InputStream.class || clazz == OutputStream.class;
    }

    protected void encodeRequest(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args, DataByteArrayOutputStream requestStream) throws Exception {
        serializationStrategy.encodeRequest(loader, method.getParameterTypes(), args, requestStream);
    }

    protected abstract ResponseFuture createResponse(SerializationStrategy var1, ClassLoader var2, Method var3, Object[] var4) throws Exception;

    @Override
    public final void service(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        if (method == null && target instanceof ServiceException) {
            this.handleInvalidRequest(serializationStrategy, loader, method, target, responseStream, onComplete);
            return;
        }
        this.doService(serializationStrategy, loader, method, target, requestStream, responseStream, onComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInvalidRequest(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        int pos = responseStream.position();
        try {
            Object value = null;
            Throwable error = (Throwable)target;
            serializationStrategy.encodeResponse(loader, null, value, error, responseStream);
        }
        catch (Exception e) {
            LOGGER.warn("Initial Encoding response for method " + method + " failed. Retrying", (Throwable)e);
            try {
                responseStream.position(pos);
                serializationStrategy.encodeResponse(loader, null, null, (Throwable)new ServiceException(e.toString()), responseStream);
            }
            catch (Exception unexpected) {
                LOGGER.error("Error while servicing " + method, (Throwable)unexpected);
            }
        }
        finally {
            onComplete.run();
        }
    }

    protected abstract void doService(SerializationStrategy var1, ClassLoader var2, Method var3, Object var4, DataByteArrayInputStream var5, DataByteArrayOutputStream var6, Runnable var7);

    protected Class getResultType(Method method) {
        return method.getReturnType();
    }

    protected class AsyncServiceResponse {
        private final ClassLoader loader;
        private final Method method;
        private final DataByteArrayOutputStream responseStream;
        private final Runnable onComplete;
        private final SerializationStrategy serializationStrategy;
        private final int pos;
        final AtomicBoolean responded = new AtomicBoolean(false);

        public AsyncServiceResponse(ClassLoader loader, Method method, DataByteArrayOutputStream responseStream, Runnable onComplete, SerializationStrategy serializationStrategy) {
            this.loader = loader;
            this.method = method;
            this.responseStream = responseStream;
            this.onComplete = onComplete;
            this.serializationStrategy = serializationStrategy;
            this.pos = responseStream.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Throwable error, Object value) {
            if (this.responded.compareAndSet(false, true)) {
                Class resultType = AbstractInvocationStrategy.this.getResultType(this.method);
                try {
                    this.serializationStrategy.encodeResponse(this.loader, resultType, value, error, this.responseStream);
                }
                catch (Exception e) {
                    try {
                        this.responseStream.position(this.pos);
                        this.serializationStrategy.encodeResponse(this.loader, resultType, value, (Throwable)new ServiceException(e.toString()), this.responseStream);
                    }
                    catch (Exception unexpected) {
                        LOGGER.error("Error while servicing " + this.method, (Throwable)unexpected);
                    }
                }
                finally {
                    this.onComplete.run();
                }
            }
        }
    }
}

