/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.primitive.DescribablePrimitive;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.AttributeDescription;
import org.eclipse.sensinact.gateway.core.Metadata;
import org.eclipse.sensinact.gateway.core.MetadataDescription;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attribute
extends DescribablePrimitive {
    private static final Logger LOG = LoggerFactory.getLogger(Attribute.class);
    public static final String NICKNAME = "nickname";
    protected final List<Metadata> metadata;
    private final ResourceImpl resource;
    private int recipient;

    public Attribute(Mediator mediator, ResourceImpl resource, String name, Class<?> type) throws InvalidValueException {
        this(mediator, resource, name, type, null, Modifiable.UPDATABLE, false);
        this.recipient = 0;
    }

    public Attribute(Mediator mediator, ResourceImpl resource, String name, Class<?> type, Object value, Modifiable modifiable, boolean hidden) throws InvalidValueException {
        super(mediator, name, type);
        this.resource = resource;
        this.metadata = new ArrayList<Metadata>();
        if (value != null) {
            super.setValue(value);
        }
        Metadata modifiableMeta = new Metadata(this.mediator, "modifiable", Modifiable.class, modifiable, Modifiable.FIXED);
        this.addMetadata(modifiableMeta);
        Metadata hiddenMeta = new Metadata(this.mediator, "hidden", Boolean.TYPE, hidden, Modifiable.FIXED);
        this.addMetadata(hiddenMeta);
        Metadata timestampMeta = new Metadata(this.mediator, "timestamp", Long.TYPE, System.currentTimeMillis(), Modifiable.UPDATABLE);
        this.addMetadata(timestampMeta);
        Metadata lockedMeta = new Metadata(this.mediator, "locked", Boolean.TYPE, false, Modifiable.UPDATABLE);
        this.addMetadata(lockedMeta);
    }

    protected Attribute(Mediator mediator, ResourceImpl resource, JSONObject attribute) throws InvalidValueException {
        super(mediator, attribute == null ? null : attribute.optString("name"), attribute == null ? null : attribute.optString("type"));
        JSONArray metadataArray;
        this.resource = resource;
        this.metadata = new ArrayList<Metadata>();
        Object ovalue = attribute.opt("value");
        if (ovalue != null) {
            this.setValue(CastUtils.getObjectFromJSON((Class)this.getType(), (Object)ovalue));
        }
        if ((metadataArray = attribute.optJSONArray("metadata")) != null) {
            for (int index = 0; index < metadataArray.length(); ++index) {
                Metadata metadata = new Metadata(this.mediator, metadataArray.getJSONObject(index));
                this.addMetadata(metadata);
            }
        }
        if (this.metadata.stream().noneMatch(m -> "modifiable".equals(m.getName()))) {
            Metadata modifiableMeta = new Metadata(this.mediator, "modifiable", Modifiable.class, Modifiable.MODIFIABLE, Modifiable.FIXED);
            this.addMetadata(modifiableMeta);
        }
        if (this.metadata.stream().noneMatch(m -> "hidden".equals(m.getName()))) {
            Metadata hiddenMeta = new Metadata(this.mediator, "hidden", Boolean.TYPE, false, Modifiable.FIXED);
            this.addMetadata(hiddenMeta);
        }
        if (this.metadata.stream().noneMatch(m -> "timestamp".equals(m.getName()))) {
            Metadata timestampMeta = new Metadata(this.mediator, "timestamp", Long.TYPE, System.currentTimeMillis(), Modifiable.UPDATABLE);
            this.addMetadata(timestampMeta);
        }
        if (this.metadata.stream().noneMatch(m -> "locked".equals(m.getName()))) {
            Metadata lockedMeta = new Metadata(this.mediator, "locked", Boolean.TYPE, false, Modifiable.UPDATABLE);
            this.addMetadata(lockedMeta);
        }
    }

    public MetadataDescription setMetadataValue(String name, Object value) throws InvalidValueException {
        Metadata metadata = null;
        if (name == null || (metadata = this.get(name)) == null) {
            return null;
        }
        metadata.setValue(value);
        MetadataDescription description = (MetadataDescription)metadata.getDescription();
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadata(Metadata metadata) {
        Metadata meta = this.get(metadata.getName());
        List<Metadata> list = this.metadata;
        synchronized (list) {
            if (meta == null) {
                this.metadata.add(metadata);
                this.weakDescription = null;
                if (!metadata.getName().equals("hidden") && metadata.getModifiable().equals((Object)Modifiable.FIXED)) {
                    this.resource.updated(this, (MetadataDescription)metadata.getDescription());
                }
            } else {
                block8: {
                    try {
                        this.setMetadataValue(metadata.getName(), metadata.getValue());
                    }
                    catch (InvalidValueException e) {
                        if (!LOG.isErrorEnabled()) break block8;
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                return;
            }
        }
    }

    public boolean removeMetadata(String metadata) {
        if (metadata == null || "hidden".intern() == metadata.intern() || "modifiable".intern() == metadata.intern() || "timestamp".intern() == metadata.intern() || "locked".intern() == metadata.intern()) {
            return false;
        }
        Metadata existingMeta = this.remove(metadata);
        return existingMeta != null;
    }

    public Object setValue(Object value) throws InvalidValueException {
        return this.setValue(value, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setValue(Object value, long timestamp) throws InvalidValueException {
        if (Modifiable.FIXED.equals((Object)this.getModifiable())) {
            throw new InvalidValueException("the value cannot be modified");
        }
        Object valueObject = this.cast(value);
        Object copy = CastUtils.copy((Class)this.type, (Object)valueObject);
        Object object = this.lock;
        synchronized (object) {
            boolean hasChanged = valueObject == null && this.value != null || valueObject != null && !valueObject.equals(this.value);
            this.beforeChange(copy);
            this.setMetadataValue("timestamp", timestamp);
            this.value = valueObject;
            this.afterChange(copy, hasChanged);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeChange(Object value) throws InvalidValueException {
        Metadata metadata = this.get("constraints");
        if (metadata == null) {
            return;
        }
        Constraint[] constraints = null;
        int length = 0;
        try {
            constraints = (Constraint[])metadata.getValue();
        }
        finally {
            if (constraints == null || (length = constraints.length) == 0) {
                return;
            }
        }
        for (int index = 0; index < length; ++index) {
            if (constraints[index].complies(value)) continue;
            StringBuilder buffer = new StringBuilder();
            buffer.append("value does not comply the constraint :");
            buffer.append(constraints[index].getJSON());
            String message = buffer.toString();
            throw new InvalidValueException(message);
        }
    }

    private void afterChange(Object value, boolean hasChanged) throws InvalidValueException {
        super.afterChange(value);
        this.resource.updated(this, value, hasChanged);
    }

    protected void addRecipient() {
        ++this.recipient;
    }

    protected void deleteRecipient() {
        --this.recipient;
    }

    protected AttributeDescription createDescription() {
        AttributeDescription description = new AttributeDescription(this, this.getAllDescriptions());
        return description;
    }

    public Modifiable getModifiable() {
        Modifiable modifiable;
        block3: {
            modifiable = Modifiable.UPDATABLE;
            Metadata metadata = null;
            metadata = this.get("modifiable");
            if (metadata == null) {
                return modifiable;
            }
            try {
                modifiable = (Modifiable)metadata.getValue();
            }
            catch (ClassCastException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return modifiable;
    }

    public boolean getLocked() {
        boolean locked = false;
        try {
            locked = (Boolean)this.get("locked").getValue();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return locked;
    }

    protected void lock() {
        try {
            this.get("locked").setValue(true);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void unlock() {
        try {
            this.get("locked").setValue(false);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isHidden() {
        Metadata metadata = this.get("hidden");
        boolean hidden = false;
        if (metadata != null) {
            try {
                hidden = (Boolean)metadata.getValue();
            }
            catch (ClassCastException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return hidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata get(String name) {
        List<Metadata> list = this.metadata;
        synchronized (list) {
            return this.metadata.stream().filter(m -> m.getName().equals(name)).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metadata remove(String name) {
        Metadata metadata = this.get(name);
        if (metadata == null) {
            List<Metadata> list = this.metadata;
            synchronized (list) {
                this.metadata.remove((Object)metadata);
                this.weakDescription = null;
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataDescription[] getAllDescriptions() {
        int index = 0;
        MetadataDescription[] descriptions = new MetadataDescription[this.metadata.size()];
        List<Metadata> list = this.metadata;
        synchronized (list) {
            Iterator<Metadata> iterator = this.metadata.iterator();
            while (iterator.hasNext()) {
                descriptions[index++] = (MetadataDescription)iterator.next().getDescription();
            }
        }
        return descriptions;
    }
}

