/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.ProcessableData;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.LifecycleStatusListener;
import org.eclipse.sensinact.gateway.core.ModelAlreadyRegisteredException;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelElement;
import org.eclipse.sensinact.gateway.core.ModelElementProxy;
import org.eclipse.sensinact.gateway.core.ModelInstanceRegistration;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModel;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.ServiceBuilder;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaMessage;
import org.eclipse.sensinact.gateway.core.message.MessageRouter;
import org.eclipse.sensinact.gateway.core.message.MidCallback;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageListener;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessNodeImpl;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.security.signature.api.BundleValidation;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInstance<C extends ModelConfiguration>
implements SensiNactResourceModel<C>,
LifecycleStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(ModelElement.class);
    public static final String LOCATION_PROPERTY = "admin.".concat("location");
    public static final String ICON_PROPERTY = "admin.".concat("icon");
    public static final String BRIDGE_PROPERTY = "admin.".concat("bridge");
    public static final String FRIENDLY_NAME_PROPERTY = "admin.".concat("friendlyName");
    protected Mediator mediator;
    protected final C configuration;
    protected ServiceProviderImpl provider;
    protected boolean registered;
    private final String identifier;
    private String namespace;
    protected MessageRouter messageRouter;
    protected final String profileId;
    private ModelInstanceRegistration registration;

    public static String defaultLocation(Mediator mediator) {
        double systemLatitude = 0.0;
        double systemLongitude = 0.0;
        try {
            systemLatitude = Double.parseDouble(mediator.getContext().getProperty("org.eclipse.sensinact.gateway.location.latitude"));
            systemLongitude = Double.parseDouble(mediator.getContext().getProperty("org.eclipse.sensinact.gateway.location.longitude"));
        }
        catch (Exception e) {
            systemLatitude = 45.19334890078532;
            systemLongitude = 5.706474781036377;
        }
        String locationStr = systemLatitude + ":" + systemLongitude;
        return locationStr;
    }

    public ModelInstance(final Mediator mediator, C modelConfiguration, String name, String profileId) throws InvalidServiceProviderException {
        this.mediator = mediator;
        this.profileId = profileId;
        this.configuration = modelConfiguration;
        List<String> initialSetOfServices = ((ModelConfiguration)this.configuration).getFixedServices(name);
        initialSetOfServices.addAll(((ModelConfiguration)this.configuration).getServices(profileId));
        this.provider = (ServiceProviderImpl)ReflectUtils.getInstance(ServiceProviderImpl.class, ((ModelConfiguration)this.configuration).getProviderImplementationType(), (Object[])new Object[]{this, name, initialSetOfServices});
        if (this.provider == null) {
            throw new InvalidServiceProviderException("Unable to instantiate the root services provider");
        }
        this.identifier = (String)this.mediator.callService(BundleValidation.class, (Executable)new Executable<BundleValidation, String>(){

            public String execute(BundleValidation service) throws Exception {
                return service.check(mediator.getContext().getBundle());
            }
        });
        this.namespace = (String)this.mediator.callService(Core.class, (Executable)new Executable<Core, String>(){

            public String execute(Core core) throws Exception {
                return core.namespace();
            }
        });
    }

    @Override
    public C configuration() {
        return this.configuration;
    }

    public ServiceBuilder getServiceBuilder() {
        ServiceBuilder builder = new ServiceBuilder(this.mediator, ServiceImpl.class);
        builder.configureImplementationClass(((ModelConfiguration)this.configuration).getServiceImplementationType());
        return builder;
    }

    public ResourceBuilder getResourceBuilder(ResourceConfig resourceConfig) {
        ResourceBuilder builder = new ResourceBuilder(this.mediator, resourceConfig);
        return builder;
    }

    protected ResourceBuilder getResourceBuilder(ResourceDescriptor descriptor, byte buildPolicy) {
        ResourceBuilder builder = null;
        if (SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_ON_DESCRIPTION)) {
            builder = this.getResourceBuilder(descriptor);
        }
        if (builder == null && SensiNactResourceModelConfiguration.BuildPolicy.isBuildPolicy(buildPolicy, SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED)) {
            builder = this.createResourceBuilder(descriptor);
        }
        return builder;
    }

    public ResourceBuilder getResourceBuilder(ResourceDescriptor descriptor) {
        ResourceConfig resourceConfig = ((ModelConfiguration)this.configuration()).getResourceConfig(descriptor);
        if (resourceConfig == null) {
            return null;
        }
        descriptor.withDataType(null);
        return this.configureResourceBuilder(resourceConfig, descriptor);
    }

    public ResourceBuilder createResourceBuilder(ResourceDescriptor descriptor) {
        ResourceConfig resourceConfig = ((ModelConfiguration)this.configuration()).createResourceConfig(descriptor);
        if (resourceConfig == null) {
            return null;
        }
        return this.configureResourceBuilder(resourceConfig, descriptor);
    }

    private <G extends ResourceConfig> ResourceBuilder configureResourceBuilder(G resourceConfig, ResourceDescriptor descriptor) {
        ResourceBuilder builder = new ResourceBuilder(this.mediator, resourceConfig);
        if (descriptor.resourceName() != null) {
            builder.configureName(descriptor.resourceName());
        }
        if (descriptor.dataType() != null) {
            builder.configureType(descriptor.dataType());
        }
        if (descriptor.dataValue() != null) {
            builder.configureValue(descriptor.dataValue());
        }
        if (descriptor.modifiable() != null) {
            builder.configureRequirement("value", AttributeBuilder.Requirement.MODIFIABLE, descriptor.modifiable());
        }
        if (descriptor.hidden() != null) {
            builder.configureRequirement("value", AttributeBuilder.Requirement.HIDDEN, (boolean)descriptor.hidden());
        }
        return builder;
    }

    @Override
    public Mediator mediator() {
        return this.mediator;
    }

    public void postMessage(SnaMessage<?> message) {
        if (this.messageRouter == null) {
            return;
        }
        ((AbstractSnaMessage)message).put("namespace", this.namespace, true);
        this.messageRouter.handle(message);
    }

    protected final void register() throws ModelAlreadyRegisteredException {
        if (this.registered) {
            throw new ModelAlreadyRegisteredException(this.registration.getName());
        }
        final String name = this.getName();
        boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Collection references = null;
                try {
                    references = ModelInstance.this.mediator.getContext().getServiceReferences(SensiNactResourceModel.class, "(name=" + name + ")");
                }
                catch (InvalidSyntaxException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                return references != null && references.size() > 0;
            }
        });
        if (exists) {
            throw new ModelAlreadyRegisteredException(name);
        }
        String uri = UriUtils.getUri((String[])new String[]{name});
        final Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("name", name);
        String location = null;
        try {
            location = this.getRootElement().getLocation();
            ((Dictionary)props).put("location", location);
        }
        catch (NullPointerException e) {
            LOG.debug(String.format("No initial location defined for %s", name));
        }
        AccessNodeImpl<Object> node = null;
        Object root = ((ModelConfiguration)this.configuration).getAccessTree().getRoot();
        AccessMethod.Type[] accessMethodTypes = AccessMethod.Type.values();
        int typesLength = accessMethodTypes == null ? 0 : accessMethodTypes.length;
        node = (AccessNodeImpl)root.get(uri);
        if (node == null) {
            node = root;
        }
        for (int index = 0; index < typesLength; ++index) {
            AccessLevelOption accessLevelOption = node.getAccessLevelOption(accessMethodTypes[index]);
            ((Dictionary)props).put(name + "." + accessMethodTypes[index].name(), accessLevelOption.getAccessLevel().getLevel());
        }
        ServiceRegistration<SensiNactResourceModel> instanceRegistration = AccessController.doPrivileged(new PrivilegedAction<ServiceRegistration<SensiNactResourceModel>>(){

            @Override
            public ServiceRegistration<SensiNactResourceModel> run() {
                return ModelInstance.this.mediator.getContext().registerService(SensiNactResourceModel.class, (Object)ModelInstance.this, props);
            }
        });
        if (instanceRegistration != null) {
            this.registered = true;
            List<String> observed = ((ModelConfiguration)this.configuration).getObserved();
            this.registration = new ModelInstanceRegistration(uri, observed, instanceRegistration, (ModelConfiguration)this.configuration);
            this.messageRouter = new SnaMessageListener(this.mediator, this.configuration());
            StringBuilder observedBuilder = Arrays.asList(LOCATION_PROPERTY, ICON_PROPERTY, FRIENDLY_NAME_PROPERTY, BRIDGE_PROPERTY).stream().collect(() -> new StringBuilder(), (sb, p) -> {
                if (sb.length() == 0) {
                    sb.append(uri.replace("/", "\\/"));
                    sb.append("(");
                } else {
                    sb.append("|");
                }
                sb.append("(");
                sb.append("\\/");
                sb.append(p.concat("(.value)?").replace(".", "\\/"));
                sb.append(")");
            }, (sb1, sb2) -> sb1.append(sb2.toString()));
            if (observed != null && !observed.isEmpty()) {
                Iterator<String> it = observed.iterator();
                block8: while (it.hasNext()) {
                    String obs = null;
                    String[] uriElements = UriUtils.getUriElements((String)it.next());
                    switch (uriElements.length) {
                        case 0: 
                        case 1: {
                            continue block8;
                        }
                        case 2: {
                            obs = UriUtils.getUri((String[])uriElements).concat("(/value)?");
                            break;
                        }
                        case 3: {
                            obs = UriUtils.getUri((String[])uriElements).replace("/value", "(/value)?");
                            break;
                        }
                        default: {
                            continue block8;
                        }
                    }
                    observedBuilder.append("|(");
                    observedBuilder.append(obs.replace("/", "\\/"));
                    observedBuilder.append(")");
                }
            }
            observedBuilder.append(")");
            SnaFilter filter = new SnaFilter(this.mediator, observedBuilder.toString(), true, false);
            filter.addHandledType(SnaMessage.Type.UPDATE);
            this.messageRouter.addCallback(filter, this.registration);
            filter = new SnaFilter(this.mediator, uri.replace("/", "\\/").concat("(\\/[^\\/]+)*"), true, false);
            filter.addHandledType(SnaMessage.Type.LIFECYCLE);
            this.messageRouter.addCallback(filter, this.registration);
            if (((ModelConfiguration)this.configuration()).getStartAtInitializationTime()) {
                this.provider.start();
            }
        }
    }

    @Override
    public final void unregister() throws IllegalStateException {
        if (!this.isRegistered()) {
            throw new IllegalStateException(this.registration.getName());
        }
        this.registered = false;
        try {
            this.getRootElement().stop();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.messageRouter.close(true);
        this.messageRouter = null;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ModelInstance.this.registration.unregister();
                return null;
            }
        });
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    public ServiceProviderImpl getRootElement() {
        return this.provider;
    }

    public String getName() {
        return this.getRootElement().getName();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void registerCallback(SnaFilter filter, MidCallback callback) {
        if (this.messageRouter == null) {
            return;
        }
        this.messageRouter.addCallback(filter, callback);
    }

    public void unregisterCallback(String callback) {
        if (this.messageRouter == null) {
            return;
        }
        this.messageRouter.deleteCallback(callback);
    }

    public String getProfile() {
        return this.profileId;
    }

    @Override
    public void update(ServiceProvider.LifecycleStatus status) {
        this.registration.updateLifecycle(status);
    }

    @Override
    public Dictionary<String, String> getProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("uri", UriUtils.getUri((String[])new String[]{this.getName()}));
        ((Dictionary)props).put("lifecycle.status", this.getRootElement().getStatus().name());
        return props;
    }

    public <I extends ModelInstance<?>, M extends ModelElementProxy, P extends ProcessableData, E extends Nameable, R extends Nameable> List<MethodAccessibility> getAuthorizations(ModelElement<I, M, P, E, R> modelElement, AccessLevelOption accessLevelOption) {
        if (modelElement.getModelInstance() != this) {
            throw new RuntimeException("the model element argument must belong to this model instance");
        }
        String path = modelElement.getPath();
        return ((ModelConfiguration)this.configuration()).getAccessibleMethods(path, accessLevelOption);
    }
}

