/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.props.TypedProperties;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessage;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessage;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractSnaMessage<S extends Enum<S> & SnaMessageSubType>
extends TypedProperties<S>
implements SnaMessage<S> {
    public static SnaMessage<?> fromJSON(Mediator mediator, String json) {
        JSONObject jsonMessage = new JSONObject(json);
        String typeStr = (String)jsonMessage.remove("type");
        String uri = (String)jsonMessage.remove("uri");
        if (typeStr == null) {
            return null;
        }
        AbstractSnaMessage message = null;
        switch (typeStr) {
            case "PROVIDER_APPEARING": 
            case "PROVIDER_DISAPPEARING": 
            case "SERVICE_APPEARING": 
            case "SERVICE_DISAPPEARING": 
            case "RESOURCE_APPEARING": 
            case "RESOURCE_DISAPPEARING": {
                SnaLifecycleMessage.Lifecycle l = SnaLifecycleMessage.Lifecycle.valueOf(typeStr);
                message = new SnaLifecycleMessageImpl(uri, l);
                break;
            }
            case "ATTRIBUTE_VALUE_UPDATED": 
            case "METADATA_VALUE_UPDATED": 
            case "ACTUATED": {
                SnaUpdateMessage.Update u = SnaUpdateMessage.Update.valueOf(typeStr);
                message = new SnaUpdateMessageImpl(uri, u);
                break;
            }
            case "CONNECTED": 
            case "DISCONNECTED": {
                SnaRemoteMessage.Remote r = SnaRemoteMessage.Remote.valueOf(typeStr);
                message = new SnaRemoteMessageImpl(uri, r);
                break;
            }
            case "NO_ERROR": 
            case "UPDATE_ERROR": 
            case "RESPONSE_ERROR": 
            case "LIFECYCLE_ERROR": 
            case "SYSTEM_ERROR": {
                SnaErrorMessage.Error e = SnaErrorMessage.Error.valueOf(typeStr);
                message = new SnaErrorMessageImpl(uri, e);
            }
        }
        if (message != null) {
            int length;
            JSONArray names = jsonMessage.names();
            int n = length = names == null ? 0 : names.length();
            for (int index = 0; index < length; ++index) {
                String name = names.getString(index);
                ((TypedProperties)message).put(name, jsonMessage.get(name));
            }
        }
        return message;
    }

    protected AbstractSnaMessage(String uri, S type) {
        super(type);
        super.putValue("uri", (Object)uri);
    }

    public String getPath() {
        return (String)super.get("uri");
    }

    public SnaMessage.Type getSnaMessageType() {
        Enum type = super.getType();
        return ((SnaMessageSubType)((Object)type)).getSnaMessageType();
    }
}

