/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method.trigger;

import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintConstantPair;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.method.trigger.AbstractAccessMethodTrigger;
import org.eclipse.sensinact.gateway.util.JSONUtils;

public class ConditionalConstant
extends AbstractAccessMethodTrigger {
    public static final String NAME = "CONDITIONAL";
    private List<ConstraintConstantPair> constants;

    public ConditionalConstant(Object argument, String argumentBuilder, boolean passOn, List<ConstraintConstantPair> constraints) throws InvalidValueException {
        super(argument, argumentBuilder, passOn);
        this.constants = constraints;
    }

    public Object execute(Object parameter) throws Exception {
        if (this.constants == null) {
            return null;
        }
        for (ConstraintConstantPair entry : this.constants) {
            if (!entry.constraint.complies(parameter)) continue;
            return entry.constant;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String doGetJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        builder.append("constants");
        builder.append('\"');
        builder.append(':');
        builder.append('[');
        if (this.constants != null) {
            Iterator<ConstraintConstantPair> iterator = this.constants.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                ConstraintConstantPair entry = iterator.next();
                builder.append(index > 0 ? Character.valueOf(',') : "");
                builder.append('{');
                builder.append('\"');
                builder.append("constant");
                builder.append('\"');
                builder.append(':');
                builder.append(JSONUtils.toJSONFormat((Object)entry.constant));
                builder.append(',');
                builder.append('\"');
                builder.append("constraint");
                builder.append('\"');
                builder.append(':');
                builder.append(entry.constraint.getJSON());
                builder.append('}');
                ++index;
            }
        }
        builder.append(']');
        return builder.toString();
    }
}

