/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server;

import io.moquette.server.config.IConfig;
import io.moquette.spi.security.ISslContextCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMoquetteSslContextCreator
implements ISslContextCreator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMoquetteSslContextCreator.class);
    private IConfig props;

    public DefaultMoquetteSslContextCreator(IConfig props) {
        this.props = props;
    }

    @Override
    public SSLContext initSSLContext() {
        String jksPath = this.props.getProperty("jks_path");
        LOG.info("Starting SSL using keystore at {}", (Object)jksPath);
        if (jksPath == null || jksPath.isEmpty()) {
            LOG.warn("You have configured the SSL port but not the jks_path, SSL not started");
            return null;
        }
        String keyStorePassword = this.props.getProperty("key_store_password");
        String keyManagerPassword = this.props.getProperty("key_manager_password");
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            LOG.warn("You have configured the SSL port but not the key_store_password, SSL not started");
            return null;
        }
        if (keyManagerPassword == null || keyManagerPassword.isEmpty()) {
            LOG.warn("You have configured the SSL port but not the key_manager_password, SSL not started");
            return null;
        }
        String sNeedsClientAuth = this.props.getProperty("need_client_auth", "false");
        boolean needsClientAuth = Boolean.valueOf(sNeedsClientAuth);
        try {
            InputStream jksInputStream = this.jksDatastore(jksPath);
            SSLContext serverContext = SSLContext.getInstance("TLS");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(jksInputStream, keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyManagerPassword.toCharArray());
            TrustManager[] trustManagers = null;
            if (needsClientAuth) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                trustManagers = tmf.getTrustManagers();
            }
            serverContext.init(kmf.getKeyManagers(), trustManagers, null);
            return serverContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOG.error("Can't start SSL layer!", (Throwable)ex);
            return null;
        }
    }

    private InputStream jksDatastore(String jksPath) throws FileNotFoundException {
        URL jksUrl = this.getClass().getClassLoader().getResource(jksPath);
        if (jksUrl != null) {
            LOG.info("Starting with jks at {}, jks normal {}", (Object)jksUrl.toExternalForm(), (Object)jksUrl);
            return this.getClass().getClassLoader().getResourceAsStream(jksPath);
        }
        LOG.info("jks not found in bundled resources, try on the filesystem");
        File jksFile = new File(jksPath);
        if (jksFile.exists()) {
            LOG.info("Using {} ", (Object)jksFile.getAbsolutePath());
            return new FileInputStream(jksFile);
        }
        LOG.warn("File {} doesn't exists", (Object)jksFile.getAbsolutePath());
        return null;
    }
}

