/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.security;

import io.moquette.server.config.IConfig;
import io.moquette.spi.security.IAuthenticator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBAuthenticator
implements IAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(DBAuthenticator.class);
    private final String sqlQuery;
    private final MessageDigest messageDigest;
    private final PreparedStatement preparedStatement;

    public DBAuthenticator(IConfig conf) {
        this(conf.getProperty("authenticator.db.driver", ""), conf.getProperty("authenticator.db.url", ""), conf.getProperty("authenticator.db.query", ""), conf.getProperty("authenticator.db.digest", ""));
    }

    public DBAuthenticator(String driver, String jdbcUrl, String sqlQuery, String digestMethod) {
        this.sqlQuery = sqlQuery;
        try {
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(jdbcUrl);
            this.messageDigest = MessageDigest.getInstance(digestMethod);
            this.preparedStatement = connection.prepareStatement(sqlQuery);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(String.format("Can't find driver %s", driver), (Throwable)cnfe);
            throw new RuntimeException(cnfe);
        }
        catch (SQLException sqle) {
            LOG.error(String.format("Can't connect to %s", jdbcUrl), (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.error(String.format("Can't find %s for password encoding", digestMethod), (Throwable)nsaex);
            throw new RuntimeException(nsaex);
        }
    }

    @Override
    public synchronized boolean checkValid(String clientId, String username, byte[] password) {
        if (username == null || password == null) {
            LOG.info("username or password was null");
            return false;
        }
        ResultSet r = null;
        try {
            this.preparedStatement.setString(1, username);
            r = this.preparedStatement.executeQuery();
            if (r.next()) {
                String foundPwq = r.getString(1);
                this.messageDigest.update(password);
                byte[] digest = this.messageDigest.digest();
                String encodedPasswd = new String(Hex.encodeHex((byte[])digest));
                return foundPwq.equals(encodedPasswd);
            }
            r.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.preparedStatement.close();
        this.preparedStatement.getConnection().close();
        super.finalize();
    }
}

