/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.checker;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.sensinact.gateway.app.api.exception.FunctionNotFoundException;
import org.eclipse.sensinact.gateway.app.api.exception.ValidationException;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.osgi.PluginsProxy;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JsonValidator.class);
    private static final String JSON_SCHEMA = "application.json";

    public static void validateApplication(AppServiceMediator mediator, JSONObject json) throws ValidationException, FileNotFoundException {
        JSONObject rawSchema = null;
        try {
            rawSchema = new JSONObject(new JSONTokener((Reader)new InputStreamReader(mediator.getContext().getBundle().getResource("/application.json").openStream())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (rawSchema == null) {
            throw new FileNotFoundException("Unable to find the JSON schema file");
        }
    }

    public static void validateFunctionsParameters(AppServiceMediator mediator, JSONArray components) throws ValidationException, FileNotFoundException {
        for (int i = 0; i < components.length(); ++i) {
            JSONObject functionSchema;
            String function = components.getJSONObject(i).getJSONObject("function").getString("name");
            try {
                functionSchema = PluginsProxy.getComponentJSONSchema(mediator, function);
            }
            catch (FunctionNotFoundException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                return;
            }
            if (functionSchema == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("The JSON of the application is not valid.");
                }
                throw new FileNotFoundException("Unable to find the JSON schema of the function: " + function);
            }
            JSONObject reformatedFunction = new JSONObject();
            reformatedFunction.put("name", (Object)function);
            if (components.getJSONObject(i).getJSONObject("function").has("buildparameters")) {
                reformatedFunction.put("buildparameters", (Object)components.getJSONObject(i).getJSONObject("function").getJSONArray("buildparameters"));
            }
            reformatedFunction.put("runparameters", (Object)components.getJSONObject(i).getJSONObject("function").getJSONArray("runparameters"));
        }
    }
}

